/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.contentassist;

import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Lexeme;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLexemeProvider<T, U>
implements ILexemeProvider<T> {
    private List<Lexeme<T>> _lexemes = new ArrayList<Lexeme<T>>();

    protected AbstractLexemeProvider(IDocument document, int offset, U scanner) {
        this(document, offset, offset, scanner);
    }

    protected AbstractLexemeProvider(IDocument document, int offset, int includeOffset, U scanner) {
        int start = offset;
        int end = offset;
        try {
            ITypedRegion partition = document.getPartition(offset);
            start = partition.getOffset();
            end = start + partition.getLength();
            start = Math.max(0, Math.min(start, includeOffset));
            end = Math.min(Math.max(end, includeOffset), document.getLength());
        }
        catch (BadLocationException badLocationException) {}
        this.createLexemeList(document, start, end - start, scanner);
    }

    protected AbstractLexemeProvider(IDocument document, IRange range, U scanner) {
        this.createLexemeList(document, range.getStartingOffset(), range.getLength(), scanner);
    }

    protected void addLexeme(Lexeme<T> lexeme) {
        this._lexemes.add(lexeme);
    }

    protected abstract void createLexemeList(IDocument var1, int var2, int var3, U var4);

    @Override
    public Lexeme<T> getCeilingLexeme(int offset) {
        int index = this.getLexemeCeilingIndex(offset);
        return this.getLexeme(index);
    }

    @Override
    public Lexeme<T> getFirstLexeme() {
        return this.getLexeme(0);
    }

    @Override
    public Lexeme<T> getFloorLexeme(int offset) {
        int index = this.getLexemeFloorIndex(offset);
        return this.getLexeme(index);
    }

    @Override
    public Lexeme<T> getLastLexeme() {
        return this.getLexeme(this.size() - 1);
    }

    @Override
    public Lexeme<T> getLexeme(int index) {
        Lexeme<T> result = null;
        if (index >= 0 && index < this._lexemes.size()) {
            result = this._lexemes.get(index);
        }
        return result;
    }

    @Override
    public int getLexemeCeilingIndex(int offset) {
        int length = this._lexemes.size();
        int result = -1;
        if (length > 0 && (result = this.getLexemeIndex(offset)) < 0 && (result = -(result + 1)) >= length) {
            result = -1;
        }
        return result;
    }

    @Override
    public int getLexemeFloorIndex(int offset) {
        int result = -1;
        if (this._lexemes.size() > 0 && (result = this.getLexemeIndex(offset)) < 0 && (result = -(result + 1) - 1) < 0) {
            result = -1;
        }
        return result;
    }

    @Override
    public Lexeme<T> getLexemeFromOffset(int offset) {
        int index = this.getLexemeIndex(offset);
        return this.getLexeme(index);
    }

    @Override
    public int getLexemeIndex(int offset) {
        int low = 0;
        int high = this._lexemes.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Lexeme<T> candidate = this._lexemes.get(mid);
            if (offset < candidate.getStartingOffset()) {
                high = mid - 1;
                continue;
            }
            if (candidate.getEndingOffset() < offset) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public Iterator<Lexeme<T>> iterator() {
        return this._lexemes.iterator();
    }

    @Override
    public int size() {
        return this._lexemes.size();
    }
}

