/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.contentassist;

import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.contentassist.ICommonCompletionProposal;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonCompletionProposal
implements ICommonCompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
Comparable<ICompletionProposal> {
    protected String _replacementString;
    protected int _replacementOffset;
    protected int _replacementLength;
    protected int _cursorPosition;
    protected Image _image;
    protected String _displayString;
    protected IContextInformation _contextInformation;
    protected String _additionalProposalInformation;
    protected String _fileLocation;
    private int _hash;
    private Image[] _userAgentImages;
    private char[] _triggerChars;
    protected boolean _isDefaultSelection;
    private boolean _isSuggestedSelection;
    private int _relevance;

    public CommonCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        this._replacementString = replacementString == null ? "" : replacementString;
        this._replacementOffset = replacementOffset;
        this._replacementLength = replacementLength;
        this._cursorPosition = cursorPosition;
        this._image = image;
        this._displayString = displayString == null ? "" : displayString;
        this._contextInformation = contextInformation;
        this._additionalProposalInformation = additionalProposalInfo;
    }

    public void apply(IDocument document) {
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (obj instanceof CommonCompletionProposal) {
            CommonCompletionProposal that = (CommonCompletionProposal)obj;
            result = ObjectUtil.areEqual((Object)this._replacementString, (Object)that._replacementString) && this._replacementOffset == that._replacementOffset && this._replacementLength == that._replacementLength && this._cursorPosition == that._cursorPosition && ObjectUtil.areEqual((Object)this._image, (Object)that._image) && ObjectUtil.areEqual((Object)this._displayString, (Object)that._displayString) && ObjectUtil.areEqual((Object)this._contextInformation, (Object)that._contextInformation) && ObjectUtil.areEqual((Object)this._additionalProposalInformation, (Object)that._additionalProposalInformation) && ObjectUtil.areEqual((Object)this._fileLocation, (Object)that._fileLocation);
        }
        return result;
    }

    public int hashCode() {
        if (this._hash == 0) {
            this._hash = this._hash * 31 + (this._replacementString != null ? this._replacementString.hashCode() : 0);
            this._hash = this._hash * 31 + this._replacementOffset;
            this._hash = this._hash * 31 + this._replacementLength;
            this._hash = this._hash * 31 + this._cursorPosition;
            this._hash = this._hash * 31 + (this.getImage() != null ? this.getImage().hashCode() : 0);
            this._hash = this._hash * 31 + (this.getDisplayString() != null ? this.getDisplayString().hashCode() : 0);
            this._hash = this._hash * 31 + (this.getContextInformation() != null ? this.getContextInformation().hashCode() : 0);
            this._hash = this._hash * 31 + (this.getAdditionalProposalInfo() != null ? this.getAdditionalProposalInfo().hashCode() : 0);
            this._hash = this._hash * 31 + (this.getFileLocation() != null ? this.getFileLocation().hashCode() : 0);
        }
        return this._hash;
    }

    public String getAdditionalProposalInfo() {
        return this._additionalProposalInformation;
    }

    public IContextInformation getContextInformation() {
        return this._contextInformation;
    }

    public String getDisplayString() {
        return this._displayString;
    }

    public String getFileLocation() {
        return this._fileLocation != null ? this._fileLocation : "";
    }

    public Image getImage() {
        return this._image;
    }

    public IRange getReplaceRange() {
        return new Range(this._replacementOffset, this._replacementOffset + this._replacementLength - 1);
    }

    public Point getSelection(IDocument document) {
        return new Point(this._replacementOffset + this._cursorPosition, 0);
    }

    public Image[] getUserAgentImages() {
        return this._userAgentImages;
    }

    public boolean isDefaultSelection() {
        return this._isDefaultSelection;
    }

    public boolean isSuggestedSelection() {
        return this._isSuggestedSelection;
    }

    public void setFileLocation(String location) {
        this._fileLocation = location;
    }

    public void setIsDefaultSelection(boolean value) {
        this._isDefaultSelection = value;
    }

    public void setIsSuggestedSelection(boolean value) {
        this._isSuggestedSelection = value;
    }

    public void setUserAgentImages(Image[] images) {
        this._userAgentImages = images;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this._replacementString;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this._replacementOffset;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        String str;
        IDocument document = viewer.getDocument();
        boolean validPrefix = this.isValidPrefix(this.getPrefix(document, offset), this.getDisplayString(), true);
        boolean validPrefixCaseSensitive = this.isValidPrefix(this.getPrefix(document, offset), this.getDisplayString(), false);
        boolean addedTrigger = false;
        char[] triggers = this.getTriggerCharacters();
        if (triggers != null && (str = new String(triggers)).indexOf(trigger) >= 0 && this._replacementString != null && this._replacementString.indexOf(trigger) < 0) {
            this._replacementString = String.valueOf(this._replacementString) + trigger;
            addedTrigger = true;
        }
        int shift = 0;
        if (validPrefix && validPrefixCaseSensitive) {
            shift = offset - this._replacementOffset;
        }
        if (shift < this._replacementString.length()) {
            int length = Math.max(0, this._replacementLength - shift);
            String toReplace = this._replacementString.substring(shift);
            if (!validPrefix || validPrefix && !validPrefixCaseSensitive) {
                offset = this._replacementOffset;
            }
            if (addedTrigger) {
                ++this._cursorPosition;
            }
            try {
                document.replace(offset, length, toReplace);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (offset < this._replacementOffset) {
            return false;
        }
        int overlapIndex = this.getDisplayString().length() - this._replacementString.length();
        overlapIndex = Math.max(0, overlapIndex);
        String endPortion = this.getDisplayString().substring(overlapIndex);
        boolean validated = this.isValidPrefix(this.getPrefix(document, offset), endPortion);
        if (validated && event != null) {
            int newLength;
            int delta = (event.fText == null ? 0 : event.fText.length()) - event.fLength;
            this._replacementLength = newLength = Math.max(this._replacementLength + delta, 0);
        }
        return validated;
    }

    protected String getPrefix(IDocument document, int offset) {
        try {
            int length = offset - this._replacementOffset;
            if (length > 0) {
                return document.get(this._replacementOffset, length);
            }
        }
        catch (BadLocationException badLocationException) {}
        return "";
    }

    protected boolean isValidPrefix(String prefix, String displayString) {
        return this.isValidPrefix(prefix, displayString, true);
    }

    protected boolean isValidPrefix(String prefix, String displayString, boolean ignoreCase) {
        if (prefix == null || displayString == null || prefix.length() > displayString.length()) {
            return false;
        }
        String start = displayString.substring(0, prefix.length());
        if (ignoreCase) {
            return start.equalsIgnoreCase(prefix);
        }
        return start.equals(prefix);
    }

    public String getExtraInfo() {
        return null;
    }

    @Override
    public int compareTo(ICompletionProposal o) {
        if (this == o) {
            return 0;
        }
        return StringUtil.compareCaseInsensitive((String)this.getDisplayString(), (String)o.getDisplayString());
    }

    public int getRelevance() {
        return this._relevance;
    }

    public void setRelevance(int relevance) {
        this._relevance = relevance;
    }

    public void apply(IDocument document, char trigger, int offset) {
    }

    public boolean isValidFor(IDocument document, int offset) {
        return false;
    }

    public void setTriggerCharacters(char[] chars) {
        this._triggerChars = chars;
    }

    public char[] getTriggerCharacters() {
        return this._triggerChars;
    }

    public int getContextInformationPosition() {
        return 0;
    }

    public boolean validateTrigger(IDocument document, int offset, KeyEvent keyEvent) {
        return true;
    }

    public String toString() {
        return this.getDisplayString();
    }
}

