/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.contentassist;

import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.hover.AbstractDocumentationHover;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.theme.ColorManager;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import java.net.URI;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorPart;

public abstract class CommonTextHover
extends AbstractDocumentationHover {
    private static ThemeListener themeListener = new ThemeListener();

    public Boolean isHoverEnabled() {
        IScopeContext[] scopes = new IScopeContext[]{EclipseUtil.instanceScope(), EclipseUtil.defaultScope()};
        return Platform.getPreferencesService().getBoolean("com.aptana.editor.common", "com.aptana.editor.common.contentAssistHover", true, scopes);
    }

    protected Color getForegroundColor() {
        return CommonTextHover.themeListener.fgColor;
    }

    protected Color getBackgroundColor() {
        return CommonTextHover.themeListener.bgColor;
    }

    protected Color getBorderColor() {
        return CommonTextHover.themeListener.borderColor;
    }

    protected IParseNode getActiveNode(ITextViewer textViewer, int offset) {
        AbstractThemeableEditor editor;
        IParseRootNode ast;
        IParseNode result = null;
        if (this.isHoverEnabled().booleanValue() && (ast = (editor = this.getEditor(textViewer)).getAST()) != null && (result = ast.getNodeAtOffset(offset)) == null) {
            if (offset < ast.getStartingOffset()) {
                result = ast.getNodeAtOffset(ast.getStartingOffset());
            } else if (ast.getEndingOffset() < offset) {
                result = ast.getNodeAtOffset(ast.getEndingOffset());
            }
        }
        return result;
    }

    protected AbstractThemeableEditor getEditor(ITextViewer textViewer) {
        AbstractThemeableEditor result = null;
        if (textViewer instanceof IAdaptable) {
            result = (AbstractThemeableEditor)((IAdaptable)textViewer).getAdapter(AbstractThemeableEditor.class);
        }
        return result;
    }

    protected URI getEditorURI(IEditorPart editorPart) {
        AbstractThemeableEditor editor = (AbstractThemeableEditor)editorPart;
        return EditorUtil.getURI((IEditorPart)editor);
    }

    protected Index getIndex(IEditorPart editorPart) {
        AbstractThemeableEditor editor = (AbstractThemeableEditor)editorPart;
        return EditorUtil.getIndex(editor);
    }

    private static class ThemeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        protected Color borderColor;
        protected Color bgColor;
        protected Color fgColor;

        ThemeListener() {
            this.getThemeColors();
            EclipseUtil.instanceScope().getNode("com.aptana.theme").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("THEME_CHANGED")) {
                this.getThemeColors();
            }
        }

        protected void getThemeColors() {
            ThemePlugin themePlugin = ThemePlugin.getDefault();
            ColorManager colorManager = themePlugin.getColorManager();
            IThemeManager themeManager = themePlugin.getThemeManager();
            Theme currentTheme = themeManager.getCurrentTheme();
            this.bgColor = colorManager.getColor(currentTheme.getBackground());
            this.fgColor = colorManager.getColor(currentTheme.getForeground());
            this.borderColor = colorManager.getColor(currentTheme.getSelectionAgainstBG());
        }
    }
}

