/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.contentassist;

import com.aptana.editor.common.contentassist.AbstractLexemeProvider;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.ITypePredicate;
import com.aptana.parsing.lexer.Lexeme;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LexemeProvider<T extends ITypePredicate>
extends AbstractLexemeProvider<T, ITokenScanner> {
    private static final Pattern WHITESPACE = Pattern.compile("\\s+", 8);

    protected LexemeProvider(IDocument document, int offset, ITokenScanner scanner) {
        super(document, offset, scanner);
    }

    protected LexemeProvider(IDocument document, int offset, int includeOffset, ITokenScanner scanner) {
        super(document, offset, includeOffset, scanner);
    }

    protected LexemeProvider(IDocument document, IRange range, ITokenScanner scanner) {
        super(document, range, scanner);
    }

    @Override
    protected void createLexemeList(IDocument document, int offset, int length, ITokenScanner scanner) {
        try {
            scanner.setRange(document, offset, length);
            IToken token = scanner.nextToken();
            while (token != Token.EOF) {
                Object data = token.getData();
                int tokenOffset = scanner.getTokenOffset();
                int tokenLength = scanner.getTokenLength();
                int endingOffset = tokenOffset + tokenLength;
                String text = document.get(tokenOffset, tokenLength);
                Object type = null;
                if (data != null) {
                    type = this.getTypeFromData(data);
                    Lexeme lexeme = new Lexeme(type, tokenOffset, endingOffset - 1, text);
                    this.addLexeme(lexeme);
                }
                if (Platform.inDevelopmentMode()) {
                    if (data != null) {
                        if (type == null || !type.isDefined()) {
                            System.out.println("Possible missed token type for text: [" + data + "]~" + text + "~");
                        }
                    } else {
                        Matcher m = WHITESPACE.matcher(text);
                        if (!m.matches()) {
                            System.out.println("Possible missed token type for text: ~" + text + "~");
                        }
                    }
                }
                token = scanner.nextToken();
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected abstract T getTypeFromData(Object var1);
}

