/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.contentassist;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ConfigurationElementDispatcher;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.ui.epl.UIEplPlugin;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAgentManager {
    public static final UserAgent[] NO_USER_AGENTS = new UserAgent[0];
    private static UserAgentManager INSTANCE;
    private static final String OTHER_NATURE_ID = "<other>";
    private static final String[] LAST_RESORT_DEFAULT_USER_AGENT;
    private static final String USER_AGENT_DELIMITER = ",";
    private static final String ENTRY_DELIMITER = ";";
    private static final String NAME_VALUE_SEPARATOR = ":";
    private static final Map<String, UserAgent> USER_AGENTS_BY_ID;
    private static Map<String, Set<String>> DEFAULT_USER_AGENT_IDS;
    private static Map<String, String[]> ACTIVE_USER_AGENTS_BY_NATURE_ID;
    private static final String USERAGENT_ID = "userAgent";
    private static final String ELEMENT_USER_AGENT = "user-agent";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ID = "id";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_ICON_DISABLED = "icon-disabled";
    private static final String ELEMENT_DEFAULT_USER_AGENTS = "default-user-agents";
    private static final String ELEMENT_USER_AGENT_REF = "user-agent-ref";
    private static final String ATTR_NATURE_ID = "nature-id";
    private static final String ATTR_USER_AGENT_ID = "user-agent-id";
    private ImageRegistry imageRegistry;

    static {
        LAST_RESORT_DEFAULT_USER_AGENT = new String[]{"IE", "Mozilla", "Chrome"};
        USER_AGENTS_BY_ID = new HashMap<String, UserAgent>();
        DEFAULT_USER_AGENT_IDS = new HashMap<String, Set<String>>();
    }

    private static void addDefaultUserAgentID(String natureID, String userAgentID) {
        if (!DEFAULT_USER_AGENT_IDS.containsKey(natureID)) {
            DEFAULT_USER_AGENT_IDS.put(natureID, new HashSet());
        }
        DEFAULT_USER_AGENT_IDS.get(natureID).add(userAgentID);
    }

    public static synchronized UserAgentManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UserAgentManager();
            INSTANCE.loadExtension();
            INSTANCE.loadPreference();
        }
        return INSTANCE;
    }

    private UserAgentManager() {
    }

    public String[] getActiveUserAgentIDs(IProject project) {
        String agents;
        if (project == null) {
            return ArrayUtil.NO_STRINGS;
        }
        String[] natureIDs = UserAgentManager.getProjectNatures(project);
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences node = scope.getNode("com.aptana.editor.common");
        if (node != null && (agents = node.get("selectUserAgents", null)) != null) {
            Map<String, String[]> userAgents = this.extractUserAgents(agents);
            return this.getActiveUserAgentIDs(userAgents, natureIDs);
        }
        return this.getActiveUserAgentIDs(natureIDs);
    }

    public static String[] getProjectNatures(IProject project) {
        String[] natureIDs = ArrayUtil.NO_STRINGS;
        try {
            natureIDs = ResourceUtil.getAptanaNatures((IProjectDescription)project.getDescription());
        }
        catch (CoreException e) {
            IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)("Problem detecting the project's nature IDs for " + project.getName()), (Throwable)e, (String)"com.aptana.editor.common/debug/content_assist");
        }
        return natureIDs;
    }

    public String[] getActiveUserAgentIDs(String ... natureIDs) {
        return this.getActiveUserAgentIDs(ACTIVE_USER_AGENTS_BY_NATURE_ID, natureIDs);
    }

    private String[] getActiveUserAgentIDs(Map<String, String[]> userAgents, String ... natureIDs) {
        String[] result = ArrayUtil.NO_STRINGS;
        if (!ArrayUtil.isEmpty((Object[])natureIDs)) {
            String natureID = natureIDs[0];
            result = userAgents.get(natureID);
        } else {
            IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)"UserAgentManager - Got empty natures list", (String)"com.aptana.editor.common/debug/content_assist");
        }
        return result;
    }

    public UserAgent[] getActiveUserAgents(IProject project) {
        return this.getUserAgentsByID(this.getActiveUserAgentIDs(project));
    }

    public UserAgent[] getActiveUserAgents(String ... natureIDs) {
        return this.getUserAgentsByID(this.getActiveUserAgentIDs(natureIDs));
    }

    public UserAgent[] getAllUserAgents() {
        Collection<UserAgent> userAgents = USER_AGENTS_BY_ID.values();
        return userAgents.toArray(new UserAgent[userAgents.size()]);
    }

    public String[] getDefaultUserAgentIDs(String natureID) {
        String[] result;
        if (DEFAULT_USER_AGENT_IDS.containsKey(natureID)) {
            Set<String> userAgentIDs = DEFAULT_USER_AGENT_IDS.get(natureID);
            result = userAgentIDs.toArray(new String[userAgentIDs.size()]);
        } else if (DEFAULT_USER_AGENT_IDS.containsKey(OTHER_NATURE_ID)) {
            Set<String> userAgentIDs = DEFAULT_USER_AGENT_IDS.get(OTHER_NATURE_ID);
            result = userAgentIDs.toArray(new String[userAgentIDs.size()]);
        } else {
            result = LAST_RESORT_DEFAULT_USER_AGENT;
        }
        return result;
    }

    public UserAgent[] getDefaultUserAgents(String natureID) {
        UserAgent[] result = NO_USER_AGENTS;
        String[] userAgentIDs = this.getDefaultUserAgentIDs(natureID);
        if (userAgentIDs != null) {
            result = this.getUserAgentsByID(userAgentIDs);
        }
        return result;
    }

    public Image getImage(String iconPath) {
        Image result = null;
        if (iconPath != null) {
            String iconFilename;
            File file;
            if (this.imageRegistry == null) {
                this.imageRegistry = new ImageRegistry();
            }
            if ((file = new File(iconPath)).exists() && (result = this.imageRegistry.get(iconFilename = file.getAbsolutePath())) == null) {
                result = new Image((Device)UIUtils.getDisplay(), iconFilename);
                this.imageRegistry.put(iconFilename, result);
            }
        }
        return result;
    }

    public Image[] getUserAgentImages(IProject project, String ... userAgents) {
        Object[] activeUserAgents = this.getActiveUserAgents(project);
        Set<Object> enabledAgents = userAgents == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(userAgents));
        Image[] result = new Image[activeUserAgents.length];
        Arrays.sort(activeUserAgents);
        int i = 0;
        while (i < activeUserAgents.length) {
            Object userAgent = activeUserAgents[i];
            if (userAgent != null) {
                result[i] = enabledAgents.contains(((UserAgent)userAgent).ID) ? this.getImage(((UserAgent)userAgent).enabledIconPath) : this.getImage(((UserAgent)userAgent).disabledIconPath);
            }
            ++i;
        }
        return result;
    }

    public UserAgent[] getUserAgentsByID(String ... ids) {
        ArrayList<UserAgent> result = new ArrayList<UserAgent>();
        if (ids != null && ids.length > 0) {
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                UserAgent userAgent = USER_AGENTS_BY_ID.get(id);
                if (userAgent != null) {
                    result.add(userAgent);
                }
                ++n2;
            }
        }
        return result.toArray(new UserAgent[result.size()]);
    }

    private void loadExtension() {
        ConfigurationElementDispatcher dispatcher = new ConfigurationElementDispatcher(new IConfigurationElementProcessor[]{new UserAgentProcessor(), new DefaultUserAgentsProcessor()});
        EclipseUtil.processConfigurationElements((String)"com.aptana.editor.common", (String)USERAGENT_ID, (IConfigurationElementProcessor)dispatcher);
    }

    public void loadPreference() {
        Map<String, String[]> result;
        ChainedPreferenceStore chainedStore = new ChainedPreferenceStore(new IPreferenceStore[]{CommonEditorPlugin.getDefault().getPreferenceStore(), UIEplPlugin.getDefault().getPreferenceStore()});
        String preferenceValue = chainedStore.getString("selectUserAgents");
        if (!StringUtil.isEmpty((String)preferenceValue)) {
            result = this.extractUserAgents(preferenceValue);
        } else {
            result = new HashMap<String, String[]>();
            for (String natureID : ResourceUtil.getAptanaNaturesMap().values()) {
                result.put(natureID, this.getDefaultUserAgentIDs(natureID));
            }
        }
        ACTIVE_USER_AGENTS_BY_NATURE_ID = result;
    }

    private Map<String, String[]> extractUserAgents(String preferenceValue) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        if (preferenceValue.contains(NAME_VALUE_SEPARATOR)) {
            String[] entries;
            String[] stringArray = entries = preferenceValue.split(ENTRY_DELIMITER);
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                String[] nameValue = entry.split(NAME_VALUE_SEPARATOR);
                String natureID = nameValue[0];
                if (nameValue.length > 1) {
                    String userAgentIDsString = nameValue[1];
                    String[] userAgentIDs = userAgentIDsString.split(USER_AGENT_DELIMITER);
                    result.put(natureID, userAgentIDs);
                } else {
                    result.put(natureID, ArrayUtil.NO_STRINGS);
                }
                ++n2;
            }
        } else {
            String[] userAgentIDs = preferenceValue.split(USER_AGENT_DELIMITER);
            for (String natureID : ResourceUtil.getAptanaNaturesMap().values()) {
                result.put(natureID, userAgentIDs);
            }
        }
        return result;
    }

    public void savePreference() {
        this.savePreference(null, ACTIVE_USER_AGENTS_BY_NATURE_ID);
    }

    public void savePreference(IProject project, Map<String, String[]> natureIdToUserAgents) {
        IEclipsePreferences preferences = null;
        preferences = project != null ? new ProjectScope(project).getNode("com.aptana.editor.common") : EclipseUtil.instanceScope().getNode("com.aptana.editor.common");
        ArrayList<String> natureEntries = new ArrayList<String>();
        for (Map.Entry<String, String[]> entry : natureIdToUserAgents.entrySet()) {
            String natureID = entry.getKey();
            String userAgentIDs = StringUtil.join((String)USER_AGENT_DELIMITER, (String[])entry.getValue());
            natureEntries.add(String.valueOf(natureID) + NAME_VALUE_SEPARATOR + userAgentIDs);
        }
        String value = StringUtil.join((String)ENTRY_DELIMITER, natureEntries);
        if (preferences != null) {
            preferences.put("selectUserAgents", value);
            try {
                preferences.flush();
            }
            catch (BackingStoreException e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)"Error saving the user-agent preferences.", (Throwable)e);
            }
        } else {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)"Error saving the user-agent preferences. Preferences node was null");
        }
    }

    public void clearPreferences(IProject project) {
        if (project != null) {
            IEclipsePreferences preferences = new ProjectScope(project).getNode("com.aptana.editor.common");
            preferences.remove("selectUserAgents");
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    public void setActiveUserAgents(String natureID, String[] userAgentIDs) {
        if (!StringUtil.isEmpty((String)natureID)) {
            String[] value = userAgentIDs != null ? userAgentIDs : ArrayUtil.NO_STRINGS;
            ACTIVE_USER_AGENTS_BY_NATURE_ID.put(natureID, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultUserAgentsProcessor
    implements IConfigurationElementProcessor {
        private DefaultUserAgentsProcessor() {
        }

        public void processElement(IConfigurationElement element) {
            String natureID = element.getAttribute(UserAgentManager.ATTR_NATURE_ID);
            IConfigurationElement[] iConfigurationElementArray = element.getChildren(UserAgentManager.ELEMENT_USER_AGENT_REF);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ref = iConfigurationElementArray[n2];
                String userAgentID = ref.getAttribute(UserAgentManager.ATTR_USER_AGENT_ID);
                UserAgentManager.addDefaultUserAgentID(natureID, userAgentID);
                ++n2;
            }
        }

        public Set<String> getSupportElementNames() {
            return CollectionsUtil.newSet((Object[])new String[]{UserAgentManager.ELEMENT_DEFAULT_USER_AGENTS});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserAgent
    implements Comparable<UserAgent> {
        public final String ID;
        public final String name;
        public final String enabledIconPath;
        public final String disabledIconPath;

        public UserAgent(String ID, String name, String enabledIconPath, String disabledIconPath) {
            this.ID = ID;
            this.name = name;
            this.enabledIconPath = enabledIconPath;
            this.disabledIconPath = disabledIconPath;
        }

        @Override
        public int compareTo(UserAgent o) {
            String name = o != null ? o.name : "";
            return this.name.compareToIgnoreCase(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UserAgentProcessor
    implements IConfigurationElementProcessor {
        private UserAgentProcessor() {
        }

        public void processElement(IConfigurationElement element) {
            String agentID = element.getAttribute(UserAgentManager.ATTR_ID);
            if (agentID != null) {
                String agentIconDisabledPath;
                Bundle bundle = Platform.getBundle((String)element.getNamespaceIdentifier());
                String agentIconPath = element.getAttribute(UserAgentManager.ATTR_ICON);
                if (agentIconPath != null) {
                    URL url = bundle.getEntry(agentIconPath);
                    agentIconPath = ResourceUtil.resourcePathToString((URL)url);
                }
                if ((agentIconDisabledPath = element.getAttribute(UserAgentManager.ATTR_ICON_DISABLED)) != null) {
                    URL url = bundle.getEntry(agentIconDisabledPath);
                    agentIconDisabledPath = ResourceUtil.resourcePathToString((URL)url);
                }
                String agentName = element.getAttribute(UserAgentManager.ATTR_NAME);
                USER_AGENTS_BY_ID.put(agentID, new UserAgent(agentID, agentName, agentIconPath, agentIconDisabledPath));
            }
        }

        public Set<String> getSupportElementNames() {
            return CollectionsUtil.newSet((Object[])new String[]{UserAgentManager.ELEMENT_USER_AGENT});
        }
    }
}

