/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.extensions;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.IDocumentScopeManager;
import com.aptana.theme.ColorManager;
import com.aptana.theme.RGBa;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class LineBackgroundPainter
implements IPainter,
LineBackgroundListener,
PaintListener {
    private ISourceViewer fViewer;
    private IPaintPositionManager fPositionManager;
    private Position fCurrentLine = new Position(0, 0);
    private Position fLastLine = new Position(0, 0);
    private int fLastLineNumber = -1;
    private boolean fIsActive;
    private Point fLastSelection = new Point(0, 0);
    private boolean fEnabled;

    public LineBackgroundPainter(ISourceViewer viewer) {
        this.fViewer = viewer;
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            if (redraw) {
                this.drawHighlightLine(this.fCurrentLine);
            }
            this.fViewer.getTextWidget().removeLineBackgroundListener((LineBackgroundListener)this);
            this.fViewer.getTextWidget().removePaintListener((PaintListener)this);
            if (this.fPositionManager != null) {
                this.fPositionManager.unmanagePosition(this.fCurrentLine);
            }
            this.fLastLineNumber = -1;
            this.fCurrentLine.offset = 0;
            this.fCurrentLine.length = 0;
        }
    }

    public void dispose() {
    }

    public void paint(int reason) {
        if (this.fViewer == null) {
            return;
        }
        if (this.fViewer.getDocument() == null) {
            this.deactivate(false);
            return;
        }
        if (!this.fIsActive) {
            StyledText textWidget = this.fViewer.getTextWidget();
            textWidget.addLineBackgroundListener((LineBackgroundListener)this);
            textWidget.addPaintListener((PaintListener)this);
            this.fPositionManager.managePosition(this.fCurrentLine);
            this.fIsActive = true;
        }
        if (this.updateHighlightLine()) {
            if (this.isOpaque() && !this.fLastLine.isDeleted() && this.fViewer instanceof ITextViewerExtension2) {
                ITextViewerExtension2 ext = (ITextViewerExtension2)this.fViewer;
                try {
                    ext.invalidateTextPresentation(this.fLastLine.getOffset(), this.fLastLine.getLength());
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                }
            }
            this.drawHighlightLine(this.fLastLine);
            this.drawHighlightLine(this.fCurrentLine);
        }
    }

    private int getModelCaret() {
        int widgetCaret = this.fViewer.getTextWidget().getCaretOffset();
        if (this.fViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fViewer;
            return extension.widgetOffset2ModelOffset(widgetCaret);
        }
        IRegion visible = this.fViewer.getVisibleRegion();
        return widgetCaret + visible.getOffset();
    }

    private boolean updateHighlightLine() {
        block5: {
            Point selection;
            int lineNumber;
            IDocument document;
            block6: {
                block7: {
                    try {
                        document = this.fViewer.getDocument();
                        int modelCaret = this.getModelCaret();
                        lineNumber = document.getLineOfOffset(modelCaret);
                        selection = this.fViewer.getTextWidget().getSelectionRange();
                        if (lineNumber == this.fLastLineNumber && this.overlaps(this.fCurrentLine, modelCaret) && selection.y == 0) break block5;
                        if (selection.y == 0 || !this.fLastLine.equals((Object)this.fCurrentLine)) break block6;
                        if (!this.fLastSelection.equals((Object)selection)) break block7;
                        return false;
                    }
                    catch (BadLocationException badLocationException) {}
                }
                this.fLastSelection = selection;
                return true;
            }
            this.fLastSelection = selection;
            this.fLastLine.offset = this.fCurrentLine.offset;
            this.fLastLine.length = this.fCurrentLine.length;
            this.fLastLine.isDeleted = this.fCurrentLine.isDeleted;
            if (this.fCurrentLine.isDeleted) {
                this.fCurrentLine.isDeleted = false;
                this.fPositionManager.managePosition(this.fCurrentLine);
            }
            this.fCurrentLine.offset = document.getLineOffset(lineNumber);
            this.fCurrentLine.length = lineNumber == document.getNumberOfLines() - 1 ? document.getLength() - this.fCurrentLine.offset : document.getLineOffset(lineNumber + 1) - this.fCurrentLine.offset;
            this.fLastLineNumber = lineNumber;
            return true;
        }
        return false;
    }

    private boolean overlaps(Position currentLine, int modelCaret) {
        if (currentLine.overlapsWith(modelCaret, 0)) {
            return true;
        }
        return modelCaret == currentLine.getOffset() + currentLine.getLength();
    }

    protected Position getCurrentLinePosition() {
        Point selection = this.fViewer.getTextWidget().getSelectionRange();
        if (selection.y != 0) {
            return null;
        }
        try {
            int line = this.fViewer.getDocument().getLineOfOffset(selection.x);
            return new Position(this.fViewer.getDocument().getLineOffset(line), 0);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private void drawHighlightLine(Position position) {
        if (!this.fEnabled) {
            return;
        }
        Rectangle rect = this.getLineRectangle(position);
        if (rect == null) {
            return;
        }
        if (!this.fViewer.getTextWidget().isDisposed()) {
            this.fViewer.getTextWidget().redraw(rect.x, rect.y, rect.width, rect.height, true);
        }
    }

    private Rectangle getLineRectangle(Position position) {
        if (position == null) {
            return null;
        }
        if (position.isDeleted()) {
            return null;
        }
        int widgetOffset = 0;
        if (this.fViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fViewer;
            widgetOffset = extension.modelOffset2WidgetOffset(position.getOffset());
            if (widgetOffset == -1) {
                return null;
            }
        } else {
            IRegion visible = this.fViewer.getVisibleRegion();
            widgetOffset = position.getOffset() - visible.getOffset();
            if (widgetOffset < 0 || visible.getLength() < widgetOffset) {
                return null;
            }
        }
        StyledText textWidget = this.fViewer.getTextWidget();
        if (widgetOffset >= 0 && widgetOffset <= textWidget.getCharCount()) {
            Point upperLeft = textWidget.getLocationAtOffset(widgetOffset);
            int width = textWidget.getClientArea().width + textWidget.getHorizontalPixel();
            int height = textWidget.getLineHeight(widgetOffset);
            return new Rectangle(0, upperLeft.y, width, height);
        }
        return null;
    }

    public void setPositionManager(IPaintPositionManager manager) {
        this.fPositionManager = manager;
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        if (this.fViewer == null) {
            return;
        }
        StyledText textWidget = this.fViewer.getTextWidget();
        if (textWidget == null) {
            return;
        }
        try {
            int offset = event.lineOffset;
            IDocument document = this.fViewer.getDocument();
            int line = document.getLineOfOffset(offset);
            IRegion lineRegion = document.getLineInformation(line);
            if (this.fEnabled && this.isOpaque() && this.isCurrentLine(line)) {
                this.drawCurrentLine(event, lineRegion);
                return;
            }
            String endOfLineScope = this.getScopeManager().getScopeAtOffset(document, lineRegion.getLength() + offset);
            String commonPrefix = this.getScope(document, line, endOfLineScope);
            TextAttribute at = this.getCurrentTheme().getTextAttribute(commonPrefix);
            event.lineBackground = at.getBackground() == null && this.isOpaque() && this.fLastLine.includes(offset) ? this.getColorManager().getColor(this.getCurrentTheme().getBackground()) : at.getBackground();
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    private boolean isOpaque() {
        RGBa lineHighlight = this.getCurrentTheme().getLineHighlight();
        return lineHighlight.isFullyOpaque();
    }

    /*
     * Unable to fully structure code
     */
    private void drawCurrentLine(LineBackgroundEvent event, IRegion lineRegion) {
        textWidget = this.fViewer.getTextWidget();
        offset = event.lineOffset;
        lineHighlight = this.getCurrentTheme().getLineHighlight();
        event.lineBackground = this.getColorManager().getColor(lineHighlight.toRGB());
        if (textWidget.isDisposed()) {
            return;
        }
        replaceLength = 160;
        if (lineRegion != null) {
            replaceLength = Math.min(replaceLength, lineRegion.getLength());
        }
        if (offset + replaceLength > (charCount = textWidget.getCharCount()) && (replaceLength = charCount - offset) < 0) {
            replaceLength = 0;
        }
        if ((ranges = textWidget.getStyleRanges(offset, replaceLength, true)) == null || ranges.length == 0) {
            return;
        }
        background = textWidget.getBackground();
        positions = new int[ranges.length << 1];
        x = 0;
        apply = false;
        var16_13 = ranges;
        var15_14 = ranges.length;
        var14_15 = 0;
        while (var14_15 < var15_14) {
            range = var16_13[var14_15];
            if (range.background == null) ** GOTO lbl30
            if (!range.background.equals((Object)background)) {
                positions[x] = range.start;
                positions[x + 1] = range.length;
                x += 2;
            } else {
                apply = true;
lbl30:
                // 2 sources

                range.background = null;
                positions[x] = range.start;
                positions[x + 1] = range.length;
                x += 2;
            }
            ++var14_15;
        }
        if (apply) {
            textWidget.setStyleRanges(offset, replaceLength, positions, ranges);
        }
    }

    protected ColorManager getColorManager() {
        return ThemePlugin.getDefault().getColorManager();
    }

    protected boolean isCurrentLine(int line) {
        try {
            int lineNumber = this.fViewer.getDocument().getLineOfOffset(this.getModelCaret());
            return line == lineNumber;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private String getScope(IDocument document, int line, String endOfLineScope) throws BadLocationException {
        int lines = document.getNumberOfLines();
        if (line + 1 >= lines) {
            return endOfLineScope;
        }
        IRegion nextLine = document.getLineInformation(line + 1);
        if (nextLine.getLength() == 0) {
            return endOfLineScope;
        }
        String startOfNextLineScope = this.getScopeManager().getScopeAtOffset(document, nextLine.getOffset());
        StringBuilder builder = new StringBuilder();
        int length = Math.min(endOfLineScope.length(), startOfNextLineScope.length());
        int i = 0;
        while (i < length) {
            char o;
            char c = endOfLineScope.charAt(i);
            if (c == (o = startOfNextLineScope.charAt(i))) {
                builder.append(c);
            }
            ++i;
        }
        return builder.toString();
    }

    public void paintControl(PaintEvent e) {
        if (!this.fEnabled) {
            return;
        }
        RGBa lineHighlight = this.getCurrentTheme().getLineHighlight();
        if (lineHighlight.isFullyOpaque()) {
            return;
        }
        Rectangle rect = new Rectangle(e.x, e.y, e.width, e.height);
        Rectangle lineRect = this.getLineRectangle(this.getCurrentLinePosition());
        if (lineRect == null || !lineRect.intersects(rect)) {
            return;
        }
        int previousAlpha = e.gc.getAlpha();
        Color previousBG = e.gc.getBackground();
        e.gc.setAlpha(lineHighlight.getAlpha());
        e.gc.setBackground(this.getColorManager().getColor(lineHighlight.toRGB()));
        e.gc.fillRectangle(lineRect.intersection(rect));
        e.gc.setAlpha(previousAlpha);
        e.gc.setBackground(previousBG);
    }

    protected Color getThemeBG() {
        return this.getColorManager().getColor(this.getCurrentTheme().getBackground());
    }

    protected Theme getCurrentTheme() {
        return ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
    }

    protected IDocumentScopeManager getScopeManager() {
        return CommonEditorPlugin.getDefault().getDocumentScopeManager();
    }

    public void setHighlightLineEnabled(boolean on) {
        this.fEnabled = on;
    }
}

