/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.IFoldingEditor;
import com.aptana.index.core.IndexFilesOfProjectJob;
import com.aptana.index.core.RemoveIndexOfFilesOfProjectJob;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFoldingEditor
extends AbstractDecoratedTextEditor
implements IFoldingEditor {
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        ProjectionSupport projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        projectionSupport.install();
        viewer.doOperation(19);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    @Override
    public synchronized void updateFoldingStructure(Map<ProjectionAnnotation, Position> annotations) {
        ArrayList<Annotation> deletions = new ArrayList<Annotation>();
        Collection<Position> additions = annotations.values();
        ProjectionAnnotationModel currentModel = this.getAnnotationModel();
        if (currentModel == null) {
            return;
        }
        Iterator iter = currentModel.getAnnotationIterator();
        while (iter.hasNext()) {
            Object annotation = iter.next();
            if (!(annotation instanceof ProjectionAnnotation)) continue;
            Position position = currentModel.getPosition((Annotation)annotation);
            if (additions.contains(position)) {
                additions.remove(position);
                continue;
            }
            deletions.add((Annotation)annotation);
        }
        if (annotations.size() != 0 || deletions.size() != 0) {
            currentModel.modifyAnnotations(deletions.toArray(new Annotation[deletions.size()]), annotations, null);
        }
    }

    protected ProjectionAnnotationModel getAnnotationModel() {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer instanceof ProjectionViewer) {
            return ((ProjectionViewer)viewer).getProjectionAnnotationModel();
        }
        return null;
    }

    protected void handleEditorInputChanged() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            this.close(false);
            return;
        }
        IEditorInput input = this.getEditorInput();
        boolean wasActivated = true;
        try {
            Field f = AbstractTextEditor.class.getDeclaredField("fHasBeenActivated");
            f.setAccessible(true);
            wasActivated = (Boolean)f.get(this);
        }
        catch (Exception exception) {}
        if (!wasActivated && !provider.isDeleted((Object)input)) {
            try {
                if (provider instanceof IDocumentProviderExtension) {
                    IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
                    extension.synchronize((Object)input);
                } else {
                    this.doSetInput(input);
                }
                return;
            }
            catch (CoreException coreException) {}
        }
        super.handleEditorInputChanged();
    }

    public void dispose() {
        try {
            IFile file;
            if (this.isDirty() && (file = this.getFile()) != null) {
                new Job("Update index"){

                    protected IStatus run(IProgressMonitor monitor) {
                        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        IProject project = file.getProject();
                        Set files = CollectionsUtil.newSet((Object[])new IFile[]{file});
                        if (sub.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        new RemoveIndexOfFilesOfProjectJob(project, files).run((IProgressMonitor)sub.newChild(10));
                        new IndexFilesOfProjectJob(project, files).run((IProgressMonitor)sub.newChild(90));
                        sub.done();
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
        finally {
            super.dispose();
        }
    }

    private IFile getFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return fileEditorInput.getFile();
        }
        return null;
    }
}

