/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.peer;

import com.aptana.core.util.ArrayUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.scope.IScopeSelector;
import com.aptana.scope.ScopeSelector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public class CharacterPairMatcher
implements ICharacterPairMatcher {
    private static final IScopeSelector fgCommentSelector = new ScopeSelector("comment");
    private int fAnchor = -1;
    private final CharPairs fPairs;
    private final String fPartitioning;
    private static Map<String, Boolean> partitionIsComment = new HashMap<String, Boolean>();

    public CharacterPairMatcher(char[] chars, String partitioning) {
        Assert.isLegal((chars.length % 2 == 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)partitioning);
        this.fPairs = new CharPairs(chars);
        this.fPartitioning = partitioning;
    }

    public CharacterPairMatcher(char[] chars) {
        this(chars, "__dftl_partitioning");
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public void dispose() {
    }

    public void clear() {
        this.fAnchor = -1;
    }

    public IRegion match(IDocument doc, int offset) {
        if (doc == null || offset < 0 || offset > doc.getLength()) {
            return null;
        }
        try {
            return this.performMatch(doc, offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IRegion performMatch(IDocument doc, int caretOffset) throws BadLocationException {
        int adjustedEndOffset;
        ITypedRegion partition;
        int charOffset = Math.max(caretOffset - 1, 0);
        char prevChar = doc.getChar(charOffset);
        if (!this.fPairs.contains(prevChar)) {
            if ((charOffset = caretOffset++) >= doc.getLength()) {
                return null;
            }
            prevChar = doc.getChar(charOffset);
            if (!this.fPairs.contains(prevChar)) {
                return null;
            }
        }
        if (this.isComment(doc, partition = this.getPartition(doc, charOffset))) {
            return null;
        }
        boolean isForward = this.fPairs.isStartCharacter(prevChar);
        String contentType = partition.getType();
        if (this.fPairs.isAmbiguous(prevChar)) {
            if ("__common_start_switch_tag".equals(contentType)) {
                isForward = true;
            } else if ("__common_end_switch_tag".equals(contentType)) {
                isForward = false;
            } else {
                String partitionAhead = TextUtilities.getContentType((IDocument)doc, (String)this.fPartitioning, (int)(charOffset + 1), (boolean)false);
                String partitionBehind = TextUtilities.getContentType((IDocument)doc, (String)this.fPartitioning, (int)(charOffset - 1), (boolean)false);
                if (contentType.equals(partitionBehind) && !contentType.equals(partitionAhead)) {
                    isForward = false;
                } else if (this.isUnclosedPair(prevChar, doc, charOffset)) {
                    isForward = false;
                }
            }
        }
        this.fAnchor = isForward ? 1 : 0;
        int searchStartPosition = isForward ? charOffset + 1 : charOffset - 1;
        char endChar = this.fPairs.getMatching(prevChar);
        int endOffset = -1;
        endOffset = isForward ? this.searchForward(doc, searchStartPosition, prevChar, endChar, contentType) : this.searchBackwards(doc, searchStartPosition, prevChar, endChar, contentType);
        if (endOffset == -1) {
            return null;
        }
        int adjustedOffset = isForward ? charOffset : caretOffset;
        int n = adjustedEndOffset = isForward ? endOffset + 1 : endOffset;
        if (adjustedEndOffset == adjustedOffset) {
            return null;
        }
        return new Region(Math.min(adjustedOffset, adjustedEndOffset), Math.abs(adjustedEndOffset - adjustedOffset));
    }

    protected ITypedRegion getPartition(IDocument doc, int charOffset) throws BadLocationException {
        return TextUtilities.getPartition((IDocument)doc, (String)this.fPartitioning, (int)charOffset, (boolean)false);
    }

    private int searchBackwards(IDocument doc, int searchStartPosition, char startChar, char endChar, String partitionType) throws BadLocationException {
        int stack = 0;
        Object[] partitions = this.computePartitioning(doc, 0, searchStartPosition + 1);
        Object[] objectArray = partitions = (ITypedRegion[])ArrayUtil.reverse((Object[])partitions);
        int n = partitions.length;
        int n2 = 0;
        while (n2 < n) {
            Object p = objectArray[n2];
            if (!this.skipPartition(p.getType(), partitionType)) {
                int partitionOffset = p.getOffset();
                int partitionEnd = partitionOffset + p.getLength() - 1;
                int startOffset = Math.min(searchStartPosition, partitionEnd);
                int length = startOffset - partitionOffset;
                String contents = doc.get(partitionOffset, length + 1);
                int i = length;
                while (i >= 0) {
                    char c = contents.charAt(i);
                    if (c == endChar) {
                        if (stack == 0) {
                            return partitionOffset + i;
                        }
                        --stack;
                    } else if (c == startChar) {
                        ++stack;
                    }
                    --i;
                }
            }
            ++n2;
        }
        return -1;
    }

    protected ITypedRegion[] computePartitioning(IDocument doc, int offset, int length) throws BadLocationException {
        return doc.computePartitioning(offset, length);
    }

    private int searchForward(IDocument doc, int searchStartPosition, char startChar, char endChar, String startPartition) throws BadLocationException {
        ITypedRegion[] partitions;
        int stack = 0;
        ITypedRegion[] iTypedRegionArray = partitions = this.computePartitioning(doc, searchStartPosition, doc.getLength() - searchStartPosition);
        int n = partitions.length;
        int n2 = 0;
        while (n2 < n) {
            ITypedRegion p = iTypedRegionArray[n2];
            if (!this.skipPartition(p.getType(), startPartition)) {
                int partitionLength = p.getLength();
                int partitionEnd = p.getOffset() + partitionLength;
                int startOffset = Math.max(searchStartPosition, p.getOffset());
                int length = partitionEnd - startOffset;
                String partitionContents = doc.get(startOffset, length);
                int i = 0;
                while (i < length) {
                    char c = partitionContents.charAt(i);
                    if (c == endChar) {
                        if (stack == 0) {
                            return i + startOffset;
                        }
                        --stack;
                    } else if (c == startChar) {
                        ++stack;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return -1;
    }

    private boolean areSwitchPartitions(String partition1, String partition2) {
        return !(!"__common_start_switch_tag".equals(partition1) && !"__common_end_switch_tag".equals(partition1) || !"__common_start_switch_tag".equals(partition2) && !"__common_end_switch_tag".equals(partition2));
    }

    private boolean skipPartition(String toCheck, String originalPartition) {
        if (toCheck == null) {
            return true;
        }
        if (toCheck.equals(originalPartition)) {
            return false;
        }
        return !this.areSwitchPartitions(toCheck, originalPartition);
    }

    protected String getScopeAtOffset(IDocument doc, int charOffset) throws BadLocationException {
        return CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset(doc, charOffset);
    }

    private boolean isUnclosedPair(char c, IDocument document, int offset) throws BadLocationException {
        int beginning = 0;
        if (document instanceof IDocumentExtension3) {
            try {
                IDocumentExtension3 ext = (IDocumentExtension3)document;
                ITypedRegion region = ext.getPartition("__dftl_partitioning", offset, false);
                beginning = region.getOffset();
            }
            catch (BadPartitioningException badPartitioningException) {}
        }
        String previous = document.get(beginning, offset - beginning);
        boolean open = false;
        int index = -1;
        while ((index = previous.indexOf(c, index + 1)) != -1) {
            boolean bl = open = !open;
        }
        return open;
    }

    protected boolean isComment(IDocument doc, ITypedRegion partition) throws BadLocationException {
        if (partitionIsComment.containsKey(partition.getType())) {
            return partitionIsComment.get(partition.getType());
        }
        String scope = this.getScopeAtOffset(doc, partition.getOffset());
        boolean isComment = fgCommentSelector.matches(scope);
        partitionIsComment.put(partition.getType(), isComment);
        return isComment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharPairs {
        private final char[] fPairs;
        private Set<Character> fCharsCache = null;

        public CharPairs(char[] pairs) {
            this.fPairs = pairs;
        }

        public boolean contains(char c) {
            return this.getAllCharacters().contains(Character.valueOf(c));
        }

        private Set<Character> getAllCharacters() {
            if (this.fCharsCache == null) {
                HashSet<Character> set = new HashSet<Character>();
                char[] cArray = this.fPairs;
                int n = this.fPairs.length;
                int n2 = 0;
                while (n2 < n) {
                    char pair = cArray[n2];
                    set.add(Character.valueOf(pair));
                    ++n2;
                }
                this.fCharsCache = set;
            }
            return this.fCharsCache;
        }

        public boolean isOpeningCharacter(char c, boolean searchForward) {
            int i = 0;
            while (i < this.fPairs.length) {
                if (searchForward && this.getStartChar(i) == c) {
                    return true;
                }
                if (!searchForward && this.getEndChar(i) == c) {
                    return true;
                }
                i += 2;
            }
            return false;
        }

        public boolean isStartCharacter(char c) {
            return this.isOpeningCharacter(c, true);
        }

        public boolean isAmbiguous(char c) {
            if (!this.isStartCharacter(c)) {
                return false;
            }
            int i = 1;
            while (i < this.fPairs.length) {
                if (this.fPairs[i] == c) {
                    return true;
                }
                i += 2;
            }
            return false;
        }

        public char getMatching(char c) {
            int i = 0;
            while (i < this.fPairs.length) {
                if (this.getStartChar(i) == c) {
                    return this.getEndChar(i);
                }
                if (this.getEndChar(i) == c) {
                    return this.getStartChar(i);
                }
                i += 2;
            }
            Assert.isTrue((boolean)false);
            return '\u0000';
        }

        private char getStartChar(int i) {
            return this.fPairs[i];
        }

        private char getEndChar(int i) {
            return this.fPairs[i + 1];
        }
    }
}

