/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.scripting;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.internal.scripting.ExtendedDocumentInfo;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.IDocumentScopeManager;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.util.EditorUtil;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.source.ISourceViewer;

public class DocumentScopeManager
implements IDocumentScopeManager {
    private static final String PROJECT_NATURE_SCOPE_PREFIX = "meta.project.";
    private static final QualifiedContentType UNKNOWN = new QualifiedContentType("com.aptana.contenttype.unknown");
    private Map<IDocument, ExtendedDocumentInfo> infos = new WeakHashMap<IDocument, ExtendedDocumentInfo>();

    public void setDocumentScope(IDocument document, String defaultContentType, String filename) {
        this.infos.put(document, new ExtendedDocumentInfo(defaultContentType, filename));
    }

    public void registerConfigurations(IDocument document, IPartitioningConfiguration[] configurations) {
        IPartitioningConfiguration[] iPartitioningConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IPartitioningConfiguration i = iPartitioningConfigurationArray[n2];
            this.registerConfiguration(document, i);
            ++n2;
        }
    }

    public void registerConfiguration(IDocument document, IPartitioningConfiguration configuration) {
        ExtendedDocumentInfo info = this.infos.get(document);
        if (info != null) {
            String[] stringArray = configuration.getContentTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String i = stringArray[n2];
                info.associateContentType(i, configuration.getDocumentContentType(i));
                ++n2;
            }
        }
    }

    public QualifiedContentType getContentType(IDocument document, int offset) throws BadLocationException {
        if (document == null) {
            return UNKNOWN;
        }
        ExtendedDocumentInfo info = this.infos.get(document);
        if (info != null) {
            return info.getContentType(document, offset);
        }
        try {
            return UNKNOWN.subtype(document.getContentType(offset));
        }
        catch (Exception exception) {
            return UNKNOWN;
        }
    }

    public String getScopeAtOffset(IDocument document, int offset) throws BadLocationException {
        return this.getPartitionScopeFragmentsAtOffset(document, offset);
    }

    public String getScopeAtOffset(ITextViewer viewer, int offset) throws BadLocationException {
        if (viewer == null) {
            return "";
        }
        IDocument document = viewer.getDocument();
        String partitionFragment = this.getPartitionScopeFragmentsAtOffset(document, offset);
        partitionFragment = String.valueOf(this.prependNaturesToScope(viewer)) + partitionFragment;
        String tokenPortion = this.getTokenScopeFragments(viewer, document, offset);
        if (tokenPortion != null) {
            if (tokenPortion.length() == 0) {
                return partitionFragment;
            }
            if (!partitionFragment.endsWith(tokenPortion)) {
                return String.valueOf(partitionFragment) + ' ' + tokenPortion;
            }
        }
        return partitionFragment;
    }

    protected String prependNaturesToScope(ITextViewer viewer) {
        if (!(viewer instanceof IAdaptable)) {
            return "";
        }
        IAdaptable adaptable = (IAdaptable)viewer;
        AbstractThemeableEditor editor = (AbstractThemeableEditor)adaptable.getAdapter(AbstractThemeableEditor.class);
        if (editor == null) {
            return "";
        }
        IProject project = EditorUtil.getProject(editor);
        if (project == null) {
            return "";
        }
        try {
            Object[] natures = project.getDescription().getNatureIds();
            if (!ArrayUtil.isEmpty((Object[])natures)) {
                return PROJECT_NATURE_SCOPE_PREFIX + StringUtil.join((String)" meta.project.", (String[])natures) + ' ';
            }
        }
        catch (CoreException coreException) {}
        return "";
    }

    private String getTokenScopeFragments(ITextViewer viewer, IDocument document, int offset) {
        Position scope;
        block12: {
            int index;
            Position[] scopes;
            block11: {
                block10: {
                    if (!(viewer instanceof ISourceViewer)) {
                        return null;
                    }
                    document.addPositionCategory("scopes");
                    scopes = document.getPositions("scopes");
                    index = document.computeIndexInCategory("scopes", offset);
                    if (scopes != null && scopes.length != 0) break block10;
                    return null;
                }
                if (index >= scopes.length) {
                    index = scopes.length - 1;
                }
                if ((scope = scopes[index]) != null) break block11;
                return null;
            }
            if (scope.includes(offset)) break block12;
            if (index > 0) {
                if ((scope = scopes[--index]) == null || !scope.includes(offset)) {
                    return null;
                }
                break block12;
            }
            return null;
        }
        try {
            if (scope instanceof TypedPosition) {
                TypedPosition pos = (TypedPosition)scope;
                return pos.getType();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    public String getPartitionScopeFragmentsAtOffset(IDocument document, int offset) throws BadLocationException {
        QualifiedContentType contentType = this.getContentType(document, offset);
        if (contentType != null) {
            QualifiedContentType translation = this.getContentTypeTranslator().translate(contentType);
            ExtendedDocumentInfo info = this.infos.get(document);
            if (info != null) {
                translation = info.modify(translation);
            }
            return translation.toString();
        }
        try {
            return document.getContentType(offset);
        }
        catch (Exception exception) {
            return UNKNOWN.toString();
        }
    }

    protected IContentTypeTranslator getContentTypeTranslator() {
        return CommonEditorPlugin.getDefault().getContentTypeTranslator();
    }

    public void dispose() {
        this.infos.clear();
    }
}

