/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.scripting;

import com.aptana.editor.common.internal.scripting.Messages;
import com.aptana.editor.common.internal.scripting.NewFileWizard;
import com.aptana.editor.common.internal.scripting.TemplateSelectionPage;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.TemplateElement;
import com.aptana.scripting.model.filters.IModelFilter;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.jruby.embed.io.ReaderInputStream;

public class WizardNewFilePage
extends WizardNewFileCreationPage {
    private TemplateElement[] templates;

    public WizardNewFilePage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    public void handleEvent(Event event) {
        if (event.type == 24) {
            this.collectTemplates();
        }
        super.handleEvent(event);
    }

    public TemplateElement[] getTemplates() {
        return this.templates;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.templates != null && this.templates.length > 0;
    }

    protected InputStream getInitialContents() {
        String templateContent;
        IWizard wizard = this.getWizard();
        TemplateSelectionPage templateSelectionPage = (TemplateSelectionPage)wizard.getPage(NewFileWizard.TEMPLATE_PAGE_NAME);
        if (wizard.getContainer().getCurrentPage() == templateSelectionPage && (templateContent = NewFileWizard.getTemplateContent(templateSelectionPage.getSelectedTemplate(), this.getContainerFullPath().append(this.getFileName()))) != null) {
            return new ReaderInputStream((Reader)new StringReader(templateContent), "UTF-8");
        }
        return super.getInitialContents();
    }

    protected boolean validatePage() {
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length == 0) {
            this.setErrorMessage(Messages.WizardNewFilePage_ERR_NoProject);
            return false;
        }
        return super.validatePage();
    }

    private void collectTemplates() {
        final String filename = this.getFileName();
        List commands = BundleManager.getInstance().getExecutableCommands(new IModelFilter(){

            public boolean include(AbstractElement element) {
                if (element instanceof TemplateElement) {
                    TemplateElement te = (TemplateElement)element;
                    String filetype = te.getFiletype();
                    if (filetype == null) {
                        return false;
                    }
                    filetype = filetype.replaceAll("\\.", "\\\\.");
                    filetype = filetype.replaceAll("\\*", ".*");
                    filetype = filetype.replaceAll("\\?", ".");
                    filetype = String.valueOf(filetype) + "$";
                    filetype = "^" + filetype;
                    return Pattern.matches(filetype, filename);
                }
                return false;
            }
        });
        if (commands != null && commands.size() > 0) {
            this.templates = new TemplateElement[commands.size()];
            int i = 0;
            while (i < commands.size()) {
                this.templates[i] = (TemplateElement)commands.get(i);
                ++i;
            }
        } else {
            this.templates = new TemplateElement[0];
        }
    }
}

