/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.outline;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.actions.BaseToggleLinkingAction;
import com.aptana.editor.common.outline.CommonOutlineContentProvider;
import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.common.outline.CommonOutlineLabelProvider;
import com.aptana.editor.common.outline.CommonOutlinePageInput;
import com.aptana.editor.common.outline.Messages;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.theme.IControlThemerFactory;
import com.aptana.theme.ThemePlugin;
import com.aptana.theme.ThemedDelegatingLabelProvider;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class CommonOutlinePage
extends ContentOutlinePage
implements IPropertyChangeListener {
    private static final String OUTLINE_CONTEXT = "com.aptana.editor.common.outline";
    private static final String INITIAL_FILTER_TEXT = Messages.CommonOutlinePage_InitialFilterText;
    private static final int FILTER_REFRESH_DELAY = 200;
    private AbstractThemeableEditor fEditor;
    private Composite fMainControl;
    private Text fSearchBox;
    private TreeViewer fTreeViewer;
    private ITreeContentProvider fContentProvider;
    private ILabelProvider fLabelProvider;
    private PatternFilter fFilter;
    private WorkbenchJob fFilterRefreshJob;
    private ToggleLinkingAction fToggleLinkingAction;
    private CommonOutlinePageInput fInput;
    private IPreferenceStore fPrefs;
    private ModifyListener fSearchModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            String text = CommonOutlinePage.this.fSearchBox.getText();
            if (INITIAL_FILTER_TEXT.equals(text)) {
                CommonOutlinePage.this.fFilter.setPattern(null);
            } else {
                CommonOutlinePage.this.fFilter.setPattern(text);
            }
            CommonOutlinePage.this.fFilterRefreshJob.cancel();
            CommonOutlinePage.this.fFilterRefreshJob.schedule(200L);
        }
    };

    public CommonOutlinePage(AbstractThemeableEditor editor, IPreferenceStore prefs) {
        this.fEditor = editor;
        this.fPrefs = prefs;
        this.fContentProvider = new CommonOutlineContentProvider();
        this.fLabelProvider = new ThemedDelegatingLabelProvider((ILabelProvider)new CommonOutlineLabelProvider());
    }

    public void createControl(Composite parent) {
        this.fMainControl = new Composite(parent, 0);
        this.fMainControl.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 2).create());
        this.fMainControl.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fSearchBox = new Text(this.fMainControl, 2180);
        this.fSearchBox.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(0, 3).create());
        this.fSearchBox.setText(INITIAL_FILTER_TEXT);
        this.fSearchBox.setForeground(this.fSearchBox.getDisplay().getSystemColor(33));
        this.fSearchBox.addModifyListener(this.fSearchModifyListener);
        this.fSearchBox.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (CommonOutlinePage.this.fSearchBox.getText().length() == 0) {
                    CommonOutlinePage.this.fSearchBox.removeModifyListener(CommonOutlinePage.this.fSearchModifyListener);
                    CommonOutlinePage.this.fSearchBox.setText(INITIAL_FILTER_TEXT);
                    CommonOutlinePage.this.fSearchBox.addModifyListener(CommonOutlinePage.this.fSearchModifyListener);
                }
                CommonOutlinePage.this.fSearchBox.setForeground(CommonOutlinePage.this.fSearchBox.getDisplay().getSystemColor(33));
            }

            public void focusGained(FocusEvent e) {
                if (CommonOutlinePage.this.fSearchBox.getText().equals(INITIAL_FILTER_TEXT)) {
                    CommonOutlinePage.this.fSearchBox.removeModifyListener(CommonOutlinePage.this.fSearchModifyListener);
                    CommonOutlinePage.this.fSearchBox.setText("");
                    CommonOutlinePage.this.fSearchBox.addModifyListener(CommonOutlinePage.this.fSearchModifyListener);
                }
                CommonOutlinePage.this.fSearchBox.setForeground(null);
            }
        });
        this.fTreeViewer = new TreeViewer(this.fMainControl, 268436226);
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fTreeViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        ((IContextService)this.getSite().getService(IContextService.class)).activateContext(OUTLINE_CONTEXT);
        final TreeViewer viewer = this.getTreeViewer();
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fInput = new CommonOutlinePageInput(this.fEditor.getAST());
        viewer.setInput((Object)this.fInput);
        viewer.setComparator(this.isSortingEnabled() ? new ViewerComparator() : null);
        this.fFilter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                String label = null;
                if (element instanceof CommonOutlineItem) {
                    label = ((CommonOutlineItem)element).getLabel();
                } else if (element instanceof IParseNode) {
                    label = ((IParseNode)element).getText();
                }
                if (label == null) {
                    return true;
                }
                return this.wordMatches(label);
            }
        };
        this.fFilter.setIncludeLeadingWildcard(true);
        viewer.addFilter((ViewerFilter)this.fFilter);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                viewer.expandToLevel(selection.getFirstElement(), 1);
                if (!CommonOutlinePage.this.isLinkedWithEditor()) {
                    CommonOutlinePage.this.setEditorSelection(selection, true);
                }
            }
        });
        viewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                IWorkbenchPage page;
                ISelection selection;
                if (e.keyCode == 13 && CommonOutlinePage.this.isLinkedWithEditor() && !(selection = viewer.getSelection()).isEmpty() && selection instanceof IStructuredSelection && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                    page.activate((IWorkbenchPart)CommonOutlinePage.this.fEditor);
                    Object widget = CommonOutlinePage.this.fEditor.getAdapter(Control.class);
                    if (widget instanceof StyledText) {
                        CommonOutlinePage.this.fEditor.selectAndReveal(((StyledText)widget).getCaretOffset(), 0);
                    }
                }
            }
        });
        this.hookToThemes();
        IActionBars actionBars = this.getSite().getActionBars();
        this.registerActions(actionBars);
        actionBars.updateActionBars();
        this.fPrefs.addPropertyChangeListener((IPropertyChangeListener)this);
        this.fFilterRefreshJob = new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (CommonOutlinePage.this.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                CommonOutlinePage.this.fTreeViewer.refresh();
                String text = CommonOutlinePage.this.fSearchBox.getText();
                if (!StringUtil.isEmpty((String)text) && !INITIAL_FILTER_TEXT.equals(text)) {
                    CommonOutlinePage.this.fTreeViewer.expandAll();
                }
                return Status.OK_STATUS;
            }
        };
        this.fFilterRefreshJob.setSystem(true);
    }

    public void refresh(IParseRootNode ast) {
        if (!this.isDisposed()) {
            this.fInput.ast = ast;
            this.getTreeViewer().refresh();
        }
    }

    public Control getControl() {
        if (this.fMainControl == null) {
            return null;
        }
        return this.fMainControl;
    }

    public ISelection getSelection() {
        if (this.fTreeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fTreeViewer.getSelection();
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void setSelection(ISelection selection) {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setSelection(selection);
        }
    }

    private void hookToThemes() {
        this.getIControlThemerFactory().apply((Viewer)this.getTreeViewer());
    }

    protected IControlThemerFactory getIControlThemerFactory() {
        return ThemePlugin.getDefault().getControlThemerFactory();
    }

    public void dispose() {
        this.fPrefs.removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
        this.getIControlThemerFactory().dispose((Viewer)this.getTreeViewer());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.isLinkedWithEditor()) {
            this.setEditorSelection((IStructuredSelection)event.getSelection(), true);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("com.aptana.editor.common.linkOutlineWithEditor")) {
            boolean isLinked = Boolean.parseBoolean(StringUtil.getStringValue((Object)event.getNewValue()));
            this.fToggleLinkingAction.setChecked(isLinked);
            TreeViewer viewer = this.getTreeViewer();
            if (isLinked) {
                this.setEditorSelection((IStructuredSelection)viewer.getSelection(), false);
            }
        } else if (property.equals("com.aptana.editor.common.sortOutlineAlphabetic")) {
            boolean sort = Boolean.parseBoolean(StringUtil.getStringValue((Object)event.getNewValue()));
            this.getTreeViewer().setComparator(sort ? new ViewerComparator() : null);
        }
    }

    public void collapseAll() {
        if (!this.isDisposed()) {
            this.getTreeViewer().collapseAll();
        }
    }

    public void expandAll() {
        if (!this.isDisposed()) {
            this.getTreeViewer().expandAll();
        }
    }

    public void expandToLevel(int level) {
        if (!this.isDisposed()) {
            this.getTreeViewer().expandToLevel(level);
        }
    }

    public Object getOutlineItem(IParseNode node) {
        if (this.fContentProvider instanceof CommonOutlineContentProvider) {
            return ((CommonOutlineContentProvider)this.fContentProvider).getOutlineItem(node);
        }
        return null;
    }

    public void refresh() {
        if (!this.isDisposed()) {
            this.getTreeViewer().refresh();
        }
    }

    public void setContentProvider(ITreeContentProvider provider) {
        this.fContentProvider = provider;
        if (!this.isDisposed()) {
            this.getTreeViewer().setContentProvider((IContentProvider)this.fContentProvider);
        }
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.fLabelProvider = new ThemedDelegatingLabelProvider(provider);
        if (!this.isDisposed()) {
            this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        }
    }

    public void select(Object element) {
        if (element != null && !this.isDisposed()) {
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection(element));
        }
    }

    private boolean isDisposed() {
        Control control = this.getControl();
        return control == null || control.isDisposed();
    }

    private void registerActions(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.add((IAction)new SortingAction());
        }
        IMenuManager menu = actionBars.getMenuManager();
        this.fToggleLinkingAction = new ToggleLinkingAction();
        menu.add((IAction)this.fToggleLinkingAction);
    }

    private void setEditorSelection(IStructuredSelection selection, boolean checkIfActive) {
        Object element;
        if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof IRange) {
            this.fEditor.select((IRange)element, checkIfActive);
        }
    }

    private boolean isLinkedWithEditor() {
        return this.fPrefs.getBoolean("com.aptana.editor.common.linkOutlineWithEditor");
    }

    private boolean isSortingEnabled() {
        return this.fPrefs.getBoolean("com.aptana.editor.common.sortOutlineAlphabetic");
    }

    public IParseRootNode getCurrentAst() {
        if (this.fInput == null) {
            return null;
        }
        return this.fInput.ast;
    }

    private class SortingAction
    extends Action {
        private static final String ICON_PATH = "icons/sort_alphab.gif";

        public SortingAction() {
            this.setText(Messages.CommonOutlinePage_Sorting_LBL);
            this.setToolTipText(Messages.CommonOutlinePage_Sorting_TTP);
            this.setDescription(Messages.CommonOutlinePage_Sorting_Description);
            this.setImageDescriptor(UIUtils.getImageDescriptor((String)"com.aptana.editor.common", (String)ICON_PATH));
            this.setChecked(CommonOutlinePage.this.isSortingEnabled());
        }

        public void run() {
            CommonOutlinePage.this.fPrefs.setValue("com.aptana.editor.common.sortOutlineAlphabetic", this.isChecked());
        }
    }

    public class ToggleLinkingAction
    extends BaseToggleLinkingAction {
        public ToggleLinkingAction() {
            this.setChecked(CommonOutlinePage.this.isLinkedWithEditor());
        }

        public void run() {
            CommonOutlinePage.this.fPrefs.setValue("com.aptana.editor.common.linkOutlineWithEditor", this.isChecked());
        }
    }
}

