/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.preferences;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.build.IBuildParticipantManager;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonSourceViewerConfiguration;
import com.aptana.editor.common.preferences.Messages;
import com.aptana.index.core.build.BuildContext;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.widgets.CListTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AbstractTextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String NAME = "name";
    private static final String BUILD = "build";
    private static final String RECONCILE = "reconcile";
    private ListViewer contentTypesViewer;
    private TableViewer validatorsViewer;
    private CListTable filterViewer;
    private List<ParticipantChanges> participants = CollectionsUtil.map((Collection)this.getBuildParticipantManager().getAllBuildParticipants(), (IMap)new IMap<IBuildParticipant, ParticipantChanges>(){

        public ParticipantChanges map(IBuildParticipant item) {
            return new ParticipantChanges(item);
        }
    });

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(CommonEditorPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        sash.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.contentTypesViewer = new ListViewer((Composite)sash, 2052);
        this.contentTypesViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.contentTypesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.contentTypesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IContentType) {
                    return ((IContentType)element).getName();
                }
                return super.getText(element);
            }
        });
        this.contentTypesViewer.addFilter((ViewerFilter)new EmptyContentTypeParticipantListFilter());
        ArrayList<IContentType> contentTypes = new ArrayList<IContentType>(this.getContentTypes());
        Collections.sort(contentTypes, new Comparator<IContentType>(){

            @Override
            public int compare(IContentType o1, IContentType o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.contentTypesViewer.setInput(contentTypes);
        this.contentTypesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ValidationPreferencePage.this.validatorsViewer != null) {
                    ValidationPreferencePage.this.updateValidators();
                    ValidationPreferencePage.this.updateFilterExpressions();
                }
            }
        });
        Composite rightComp = new Composite((Composite)sash, 0);
        rightComp.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Control validators = this.createValidators(rightComp);
        validators.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Control filter = this.createFiltersComposite(rightComp);
        filter.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        sash.setWeights(new int[]{1, 3});
        return sash;
    }

    protected IBuildParticipantManager getBuildParticipantManager() {
        return BuildPathCorePlugin.getDefault().getBuildParticipantManager();
    }

    protected void performDefaults() {
        for (IBuildParticipant iBuildParticipant : this.participants) {
            iBuildParticipant.restoreDefaults();
        }
        this.validatorsViewer.refresh();
        this.updateFilterExpressions();
        super.performDefaults();
    }

    public boolean performOk() {
        boolean rebuild = this.rebuild();
        boolean reReconcile = this.needsReconcile();
        ApplyChangesAndBuildJob buildJob = new ApplyChangesAndBuildJob(Messages.ValidationPreferencePage_RebuildJobTitle, rebuild, reReconcile);
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof IWorkbenchPreferenceContainer) {
            ((IWorkbenchPreferenceContainer)container).registerUpdateJob((Job)buildJob);
        } else {
            buildJob.schedule();
        }
        return true;
    }

    private boolean needsReconcile() {
        for (ParticipantChanges change : this.participants) {
            if (!change.needsReconcile()) continue;
            return true;
        }
        return false;
    }

    private boolean rebuild() {
        if (this.promptForRebuild()) {
            MessageDialog dialog = new MessageDialog(this.getShell(), Messages.ValidationPreferencePage_RebuildDialogTitle, null, Messages.ValidationPreferencePage_RebuildDialogMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            return dialog.open() == 0;
        }
        return false;
    }

    private boolean promptForRebuild() {
        for (ParticipantChanges change : this.participants) {
            if (!change.needsRebuild()) continue;
            return true;
        }
        return false;
    }

    private Control createValidators(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.ValidationPreferencePage_LBL_Validators);
        group.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(4, 4).create());
        Label label = new Label((Composite)group, 64);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().hint(300, 70).create());
        label.setText(Messages.ValidationPreferencePage_EnablingValidatorWarning);
        Table table = new Table((Composite)group, 68356);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn name = new TableColumn(table, 16384);
        name.setWidth(250);
        name.setText(Messages.ValidationPreferencePage_NameColumn);
        name.setToolTipText(Messages.ValidationPreferencePage_NameColumn);
        TableColumn build = new TableColumn(table, 0x1000000);
        build.setWidth(40);
        build.setText(Messages.ValidationPreferencePage_BuildColumn);
        build.setToolTipText(Messages.ValidationPreferencePage_BuildColumn);
        TableColumn reconcile = new TableColumn(table, 0x1000000);
        reconcile.setWidth(75);
        reconcile.setText(Messages.ValidationPreferencePage_ReconcileColumn);
        reconcile.setToolTipText(Messages.ValidationPreferencePage_ReconcileColumn);
        this.validatorsViewer = new TableViewer(table);
        this.validatorsViewer.setColumnProperties(new String[]{NAME, BUILD, RECONCILE});
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = new CheckboxCellEditor((Composite)table);
        cellEditorArray[2] = new CheckboxCellEditor((Composite)table);
        this.validatorsViewer.setCellEditors(cellEditorArray);
        this.validatorsViewer.setCellModifier((ICellModifier)new ParticipantCellModifier(this.validatorsViewer));
        this.validatorsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.validatorsViewer.setLabelProvider((IBaseLabelProvider)new ParticipantLabelProvider());
        this.validatorsViewer.addFilter((ViewerFilter)new RequiredParticipantFilter());
        this.validatorsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ValidationPreferencePage.this.updateFilterExpressions();
            }
        });
        this.updateValidators();
        return group;
    }

    private Control createFiltersComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.ValidationPreferencePage_LBL_Filter);
        group.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(4, 4).create());
        this.filterViewer = new CListTable((Composite)group, 0);
        this.filterViewer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.filterViewer.setDescription(Messages.ValidationPreferencePage_Filter_SelectParticipant);
        final IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                if (StringUtil.isEmpty((String)newText)) {
                    return Messages.ValidationPreferencePage_ERR_EmptyExpression;
                }
                return null;
            }
        };
        this.filterViewer.addListener(new CListTable.Listener(){

            public Object addItem() {
                InputDialog dialog = new InputDialog(ValidationPreferencePage.this.getShell(), Messages.ValidationPreferencePage_Ignore_Title, Messages.ValidationPreferencePage_Ignore_Message, null, inputValidator);
                if (dialog.open() == 0) {
                    return dialog.getValue();
                }
                return null;
            }

            public Object editItem(Object item) {
                String expression = item.toString();
                InputDialog dialog = new InputDialog(ValidationPreferencePage.this.getShell(), Messages.ValidationPreferencePage_Ignore_Title, Messages.ValidationPreferencePage_Ignore_Message, expression, inputValidator);
                if (dialog.open() == 0) {
                    return dialog.getValue();
                }
                return item;
            }

            public void itemsChanged(List<Object> rawFilters) {
                ParticipantChanges participant = ValidationPreferencePage.this.getSelectedBuildParticipant();
                String[] filters = new String[rawFilters.size()];
                int i = 0;
                for (Object item : rawFilters) {
                    filters[i++] = item.toString();
                }
                participant.setFilters((IScopeContext)EclipseUtil.instanceScope(), filters);
            }
        });
        this.filterViewer.setEnabled(false);
        return group;
    }

    protected Set<IContentType> getContentTypes() {
        return this.getBuildParticipantManager().getContentTypes();
    }

    private void updateValidators() {
        IContentType selected = this.getSelectedContentType();
        if (selected == null) {
            this.validatorsViewer.setInput(Collections.emptyList());
        } else {
            this.validatorsViewer.setInput(this.getBuildParticipants(selected.getId()));
        }
    }

    private List<IBuildParticipant> getBuildParticipants(String contentTypeId) {
        List participantsForContentType = this.getBuildParticipantManager().filterParticipants(this.participants, contentTypeId);
        return CollectionsUtil.filter((Collection)participantsForContentType, (IFilter)new IFilter<IBuildParticipant>(){

            public boolean include(IBuildParticipant participant) {
                return !StringUtil.isEmpty((String)participant.getName());
            }
        });
    }

    private ParticipantChanges getSelectedBuildParticipant() {
        IStructuredSelection selection = (IStructuredSelection)this.validatorsViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (ParticipantChanges)selection.getFirstElement();
    }

    private void updateFilterExpressions() {
        ParticipantChanges participant = this.getSelectedBuildParticipant();
        if (participant != null) {
            this.filterViewer.setEnabled(true);
            this.filterViewer.setDescription(Messages.ValidationPreferencePage_Filter_Description);
            List expressions = participant.getFilters();
            this.filterViewer.setItems(expressions.toArray());
        } else {
            this.filterViewer.setEnabled(false);
            this.filterViewer.setDescription(Messages.ValidationPreferencePage_Filter_SelectParticipant);
            this.filterViewer.setItems(ArrayUtil.NO_OBJECTS);
        }
    }

    private IContentType getSelectedContentType() {
        IStructuredSelection selection = (IStructuredSelection)this.contentTypesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (IContentType)selection.getFirstElement();
    }

    private final class ApplyChangesAndBuildJob
    extends Job {
        private final boolean rebuild;
        private final boolean reReconcile;

        private ApplyChangesAndBuildJob(String name, boolean rebuild, boolean reReconcile) {
            super(name);
            this.rebuild = rebuild;
            this.reReconcile = reReconcile;
            this.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ValidationPreferencePage_RebuildJobTaskName, (int)100);
            try {
                try {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    if (this.rebuild) {
                        sub.subTask(Messages.ValidationPreferencePage_CleaningProjects);
                        workspace.build(15, (IProgressMonitor)sub.newChild(20));
                        sub.setWorkRemaining(80);
                    }
                    sub.subTask(Messages.ValidationPreferencePage_ApplyingChangesToParticipants);
                    for (ParticipantChanges change : ValidationPreferencePage.this.participants) {
                        change.apply();
                    }
                    sub.worked(10);
                    if (this.reReconcile) {
                        UIJob job = new UIJob(Messages.ValidationPreferencePage_ForcingReconcile){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                IEditorReference[] refs = UIUtils.getActivePage().getEditorReferences();
                                monitor.beginTask(Messages.ValidationPreferencePage_ReconcilingOpenEditors, refs.length);
                                IEditorReference[] iEditorReferenceArray = refs;
                                int n = refs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IEditorReference ref = iEditorReferenceArray[n2];
                                    if (monitor.isCanceled()) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    IEditorPart part = ref.getEditor(false);
                                    if (part instanceof AbstractTextEditor) {
                                        monitor.subTask(part.getTitle());
                                        if (part instanceof AbstractThemeableEditor) {
                                            AbstractThemeableEditor ate = (AbstractThemeableEditor)part;
                                            CommonSourceViewerConfiguration csvc = (CommonSourceViewerConfiguration)ate.getAdapter(SourceViewerConfiguration.class);
                                            csvc.forceReconcile();
                                        } else {
                                            AbstractTextEditor editor = (AbstractTextEditor)part;
                                            IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                                            doc.set(doc.get());
                                        }
                                    }
                                    monitor.worked(1);
                                    ++n2;
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule(500L);
                    }
                    if (this.rebuild) {
                        sub.subTask(Messages.ValidationPreferencePage_RebuildingProjects);
                        workspace.build(6, (IProgressMonitor)sub.newChild(70));
                    }
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    sub.done();
                    return iStatus;
                }
                catch (OperationCanceledException operationCanceledException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    sub.done();
                    return iStatus;
                }
            }
            finally {
                sub.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }

    private final class EmptyContentTypeParticipantListFilter
    extends ViewerFilter {
        private EmptyContentTypeParticipantListFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IContentType) {
                IContentType type = (IContentType)element;
                List participants = ValidationPreferencePage.this.getBuildParticipants(type.getId());
                if (CollectionsUtil.isEmpty((Collection)participants)) {
                    return false;
                }
                for (IBuildParticipant participant : participants) {
                    if (participant.isRequired()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private final class ParticipantCellModifier
    implements ICellModifier {
        private TableViewer tableViewer;

        private ParticipantCellModifier(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                element = ((TableItem)element).getData();
            }
            IBuildParticipant participant = (IBuildParticipant)element;
            if (ValidationPreferencePage.BUILD.equals(property)) {
                participant.setEnabled(IBuildParticipant.BuildType.BUILD, ((Boolean)value).booleanValue());
            } else if (ValidationPreferencePage.RECONCILE.equals(property)) {
                participant.setEnabled(IBuildParticipant.BuildType.RECONCILE, ((Boolean)value).booleanValue());
            }
            this.tableViewer.refresh((Object)participant);
        }

        public Object getValue(Object element, String property) {
            IBuildParticipant participant = (IBuildParticipant)element;
            if (ValidationPreferencePage.BUILD.equals(property)) {
                return participant.isEnabled(IBuildParticipant.BuildType.BUILD);
            }
            if (ValidationPreferencePage.RECONCILE.equals(property)) {
                return participant.isEnabled(IBuildParticipant.BuildType.RECONCILE);
            }
            return null;
        }

        public boolean canModify(Object element, String property) {
            return ValidationPreferencePage.BUILD.equals(property) || ValidationPreferencePage.RECONCILE.equals(property);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParticipantChanges
    implements IBuildParticipant {
        private IBuildParticipant wrapped;
        private Boolean enabledForBuild;
        private Boolean enabledForReconcile;
        private List<String> filters;
        private IScopeContext context;

        public ParticipantChanges(IBuildParticipant wrapped) {
            this.wrapped = wrapped;
        }

        public void clean(IProject project, IProgressMonitor monitor) {
            this.wrapped.clean(project, monitor);
        }

        public void buildStarting(IProject project, int kind, IProgressMonitor monitor) {
            this.wrapped.buildStarting(project, kind, monitor);
        }

        public void buildEnding(IProgressMonitor monitor) {
            this.wrapped.buildEnding(monitor);
        }

        public int getPriority() {
            return this.wrapped.getPriority();
        }

        public void buildFile(BuildContext context, IProgressMonitor monitor) {
            this.wrapped.buildFile(context, monitor);
        }

        public void deleteFile(BuildContext context, IProgressMonitor monitor) {
            this.wrapped.deleteFile(context, monitor);
        }

        public Set<IContentType> getContentTypes() {
            return this.wrapped.getContentTypes();
        }

        public String getName() {
            return this.wrapped.getName();
        }

        public String getId() {
            return this.wrapped.getId();
        }

        public boolean isEnabled(IBuildParticipant.BuildType type) {
            switch (type) {
                case BUILD: {
                    if (this.enabledForBuild == null) break;
                    return this.enabledForBuild;
                }
                case RECONCILE: {
                    if (this.enabledForReconcile == null) break;
                    return this.enabledForReconcile;
                }
            }
            return this.wrapped.isEnabled(type);
        }

        public void setEnabled(IBuildParticipant.BuildType type, boolean enabled) {
            switch (type) {
                case BUILD: {
                    this.enabledForBuild = enabled;
                    break;
                }
                case RECONCILE: {
                    this.enabledForReconcile = enabled;
                    break;
                }
            }
        }

        public void restoreDefaults() {
            this.wrapped.restoreDefaults();
            this.enabledForBuild = null;
            this.enabledForReconcile = null;
            this.filters = null;
        }

        public boolean isRequired() {
            return this.wrapped.isRequired();
        }

        public List<String> getFilters() {
            if (this.filters != null) {
                return this.filters;
            }
            return this.wrapped.getFilters();
        }

        public boolean isEnabled(IProject project) {
            return this.wrapped.isEnabled(project);
        }

        public void setFilters(IScopeContext context, String ... filters) {
            this.context = context;
            this.filters = CollectionsUtil.newList((Object[])filters);
        }

        public boolean needsRebuild() {
            return this.enabledForBuild != null || this.filters != null && this.wrapped.isEnabled(IBuildParticipant.BuildType.BUILD);
        }

        public void apply() {
            if (this.enabledForBuild != null) {
                this.wrapped.setEnabled(IBuildParticipant.BuildType.BUILD, this.enabledForBuild.booleanValue());
                this.enabledForBuild = null;
            }
            if (this.enabledForReconcile != null) {
                this.wrapped.setEnabled(IBuildParticipant.BuildType.RECONCILE, this.enabledForReconcile.booleanValue());
                this.enabledForReconcile = null;
            }
            if (this.filters != null) {
                ((AbstractBuildParticipant)this.wrapped).setFilters(this.context, this.filters.toArray(new String[this.filters.size()]));
                this.filters = null;
                this.context = null;
            }
        }

        public boolean needsReconcile() {
            return this.enabledForReconcile != null || this.filters != null && this.wrapped.isEnabled(IBuildParticipant.BuildType.RECONCILE);
        }
    }

    private static final class ParticipantLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final String RED_X_ICON = "platform:/plugin/com.aptana.ui/icons/delete.gif";
        private static final String CHECKMARK_ICON = "platform:/plugin/com.aptana.ui/icons/ok.png";

        private ParticipantLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            IBuildParticipant participant = (IBuildParticipant)element;
            if (columnIndex == 0) {
                return participant.getName();
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            IBuildParticipant participant = (IBuildParticipant)element;
            if (columnIndex == 1) {
                if (participant.isEnabled(IBuildParticipant.BuildType.BUILD)) {
                    return UIUtils.getImage((AbstractUIPlugin)CommonEditorPlugin.getDefault(), (String)CHECKMARK_ICON);
                }
                return UIUtils.getImage((AbstractUIPlugin)CommonEditorPlugin.getDefault(), (String)RED_X_ICON);
            }
            if (columnIndex == 2) {
                if (participant.isEnabled(IBuildParticipant.BuildType.RECONCILE)) {
                    return UIUtils.getImage((AbstractUIPlugin)CommonEditorPlugin.getDefault(), (String)CHECKMARK_ICON);
                }
                return UIUtils.getImage((AbstractUIPlugin)CommonEditorPlugin.getDefault(), (String)RED_X_ICON);
            }
            return null;
        }
    }

    private static final class RequiredParticipantFilter
    extends ViewerFilter {
        private RequiredParticipantFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IBuildParticipant) {
                IBuildParticipant participant = (IBuildParticipant)element;
                return !participant.isRequired();
            }
            return true;
        }
    }
}

