/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.properties;

import com.aptana.editor.common.properties.AdaptableTextSelection;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class CommonEditorPropertySheetPage
extends PropertySheetPage {
    private final ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            CommonEditorPropertySheetPage.this.textSelectionChanged((ITextSelection)event.getSelection());
        }
    };
    private final IPartListener partListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            CommonEditorPropertySheetPage.this.removePostSelectionListener();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }
    };
    private AbstractTextEditor sourcePart;
    private ISourceViewer viewer;

    public CommonEditorPropertySheetPage(ISourceViewer viewer) {
        this.viewer = viewer;
    }

    private ISourceViewer getViewer() {
        return this.viewer;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.removePostSelectionListener();
        if (selection instanceof ITextSelection && part instanceof AbstractTextEditor) {
            selection = new StructuredSelection((Object)new AdaptableTextSelection(this.getViewer(), (ITextSelection)selection));
            this.sourcePart = (AbstractTextEditor)part;
            ((IPostSelectionProvider)this.sourcePart.getSelectionProvider()).addPostSelectionChangedListener(this.selectionChangedListener);
            this.sourcePart.getSite().getPage().addPartListener(this.partListener);
        }
        super.selectionChanged(part, selection);
    }

    private void textSelectionChanged(ITextSelection textSelection) {
        if (this.sourcePart != null) {
            StructuredSelection selection = new StructuredSelection((Object)new AdaptableTextSelection(this.getViewer(), textSelection));
            super.selectionChanged((IWorkbenchPart)this.sourcePart, (ISelection)selection);
        }
    }

    private void removePostSelectionListener() {
        if (this.sourcePart != null) {
            ((IPostSelectionProvider)this.sourcePart.getSelectionProvider()).removePostSelectionChangedListener(this.selectionChangedListener);
            this.sourcePart = null;
        }
    }

    public void dispose() {
        if (this.sourcePart != null) {
            this.sourcePart.getSite().getPage().removePartListener(this.partListener);
        }
        this.removePostSelectionListener();
        super.dispose();
    }
}

