/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.resolver;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.resolver.IPathResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

public class URIResolver
implements IPathResolver {
    private URI baseURI;

    public URIResolver(URI baseURI) {
        this.baseURI = baseURI;
    }

    public String resolveSource(String path, IProgressMonitor monitor) throws Exception {
        File aFile;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        URI uri = this.resolveURI(path);
        if (uri == null) {
            return null;
        }
        sub.worked(5);
        IFileStore store = this.getFileStore(uri);
        int options = 4096;
        if (store.getFileSystem().equals(EFS.getLocalFileSystem())) {
            options = 0;
        }
        if ((aFile = store.toLocalFile(options, (IProgressMonitor)sub.newChild(90))) == null || !aFile.exists()) {
            throw new FileNotFoundException(uri.toString());
        }
        return IOUtil.read((InputStream)new FileInputStream(aFile));
    }

    protected IFileStore getFileStore(URI uri) throws CoreException {
        IFileSystem fileSystem = EFS.getFileSystem((String)uri.getScheme());
        if (fileSystem == null) {
            return EFS.getNullFileSystem().getStore(uri);
        }
        return fileSystem.getStore(uri);
    }

    public URI resolveURI(String path) {
        URI uri;
        if (path == null) {
            return null;
        }
        try {
            uri = URI.create(path);
            String scheme = uri.getScheme();
            if (scheme == null) {
                uri = this.baseURI.resolve(path);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                uri = this.baseURI.resolve(path);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return null;
            }
        }
        try {
            IFileStore store = this.getFileStore(uri);
            IFileInfo info = store.fetchInfo();
            if (info.exists()) {
                return uri;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }
}

