/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.scripting.snippets;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;

public class SnippetTemplateTranslator
extends TemplateTranslator {
    private static final String ZERO = "0";
    private static final String SINGLE_QUOTE = "'";
    private static final String OR = "|";
    private static final String COLON = ":";
    private static final String DOLLAR_LEFT_BRACE = "${";
    private static final String RIGHT_BRACE = "}";
    private static final String EMPTY_DEFAULT_VALUE = "('')";
    private static final String CURSOR = "${cursor}";
    private static final String SPACES = "\\s*+";
    private static final String NON_CURLY_BRACE_SNIPPET_VARIABLE_PATTERN_STRING = "\\$([\\p{Alnum}_]+)";
    private static final Pattern NON_CURLY_BRACE_SNIPPET_VARIABLE_PATTERN = Pattern.compile("\\$([\\p{Alnum}_]+)");
    private static final String CURLY_BRACE_SNIPPET_VARIABLE_PATTERN_STRING = "\\$\\{\\s*+([\\p{Alnum}_]+)\\s*+(:((?:\\\\.|[^}])+))?\\}";
    private static final Pattern CURLY_BRACE_SNIPPET_VARIABLE_PATTERN = Pattern.compile("\\$\\{\\s*+([\\p{Alnum}_]+)\\s*+(:((?:\\\\.|[^}])+))?\\}");
    private static final String REVERSE_TICK_PATTERN_STRING = "`[^`]*`";
    private static final Pattern SNIPPET_VARIABLE_COMMANDS_AND_ESCAPES = Pattern.compile("\\\\`|\\\\\\$|`[^`]*`|\\$([\\p{Alnum}_]+)|\\$\\{\\s*+([\\p{Alnum}_]+)\\s*+(:((?:\\\\.|[^}])+))?\\}");

    public TemplateBuffer translate(Template template) throws TemplateException {
        return super.translate(SnippetTemplateTranslator.processExpansion(template.getPattern()));
    }

    static String processExpansion(String string) {
        StringBuffer buffer = new StringBuffer(string.length());
        Matcher matcher = SNIPPET_VARIABLE_COMMANDS_AND_ESCAPES.matcher(string);
        HashSet<String> seenVariables = new HashSet<String>();
        int complete = 0;
        while (matcher.find()) {
            String name;
            Matcher m;
            buffer.append(string.substring(complete, matcher.start()));
            String matched = matcher.group();
            if ("\\`".equals(matched)) {
                buffer.append('`');
            } else if ("\\$".equals(matched)) {
                buffer.append("$$");
            } else if (matched.startsWith("`")) {
                buffer.append(matcher.group());
            } else if (matched.startsWith(DOLLAR_LEFT_BRACE)) {
                m = CURLY_BRACE_SNIPPET_VARIABLE_PATTERN.matcher(matched);
                m.find();
                name = m.group(1);
                if (ZERO.equals(name)) {
                    buffer.append(CURSOR);
                } else {
                    buffer.append(DOLLAR_LEFT_BRACE);
                    if (seenVariables.add(name)) {
                        try {
                            Integer.parseInt(name);
                            buffer.append(String.valueOf(name) + COLON + "tabstop");
                        }
                        catch (NumberFormatException numberFormatException) {
                            buffer.append(String.valueOf(name) + COLON + "environment");
                        }
                        String defaultValues = m.group(2);
                        if (defaultValues != null) {
                            String[] values;
                            if (defaultValues.startsWith(COLON)) {
                                defaultValues = defaultValues.substring(1);
                            }
                            buffer.append('(');
                            boolean first = true;
                            String[] stringArray = values = defaultValues.split("(?<!\\\\)/");
                            int n = values.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String value = stringArray[n2];
                                if (first) {
                                    first = false;
                                } else {
                                    buffer.append(',');
                                }
                                buffer.append(SINGLE_QUOTE);
                                buffer.append(value.replaceAll(Pattern.quote("\\$"), Matcher.quoteReplacement("$")).replaceAll("\\\\/", "/").replaceAll("\\\\}", "\\}").replaceAll(SINGLE_QUOTE, "''").replaceAll("\\\\`", "`"));
                                buffer.append(SINGLE_QUOTE);
                                ++n2;
                            }
                            buffer.append(')');
                        } else {
                            buffer.append(EMPTY_DEFAULT_VALUE);
                        }
                    } else {
                        buffer.append(name);
                    }
                    buffer.append(RIGHT_BRACE);
                }
            } else {
                m = NON_CURLY_BRACE_SNIPPET_VARIABLE_PATTERN.matcher(matched);
                m.find();
                name = m.group(1);
                if (ZERO.equals(name)) {
                    buffer.append(CURSOR);
                } else {
                    buffer.append(DOLLAR_LEFT_BRACE);
                    if (seenVariables.add(name)) {
                        try {
                            Integer.parseInt(name);
                            buffer.append(String.valueOf(name) + COLON + "tabstop");
                        }
                        catch (NumberFormatException numberFormatException) {
                            buffer.append(String.valueOf(name) + COLON + "environment");
                        }
                        buffer.append(EMPTY_DEFAULT_VALUE);
                    } else {
                        buffer.append(name);
                    }
                    buffer.append(RIGHT_BRACE);
                }
            }
            complete = matcher.end();
        }
        buffer.append(string.substring(complete));
        String result = buffer.toString();
        result = result.replaceAll("\\\\/", "/");
        result = result.replaceAll(Pattern.quote("\\\\"), Matcher.quoteReplacement("\\"));
        return result;
    }
}

