/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.spelling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;
import org.eclipse.ui.texteditor.spelling.SpellingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiRegionSpellingReconcileStrategy
extends SpellingReconcileStrategy {
    private final String documentPartitioning;
    private final Collection<String> contentTypes;
    private IRegion currentRegion;

    public MultiRegionSpellingReconcileStrategy(ISourceViewer viewer, SpellingService spellingService, String documentPartitioning, Collection<String> contentTypes) {
        super(viewer, spellingService);
        this.documentPartitioning = documentPartitioning;
        this.contentTypes = contentTypes;
    }

    protected ISpellingProblemCollector createSpellingProblemCollector() {
        IAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return null;
        }
        return new SpellingProblemCollector(model);
    }

    public void initialReconcile() {
        ITypedRegion[] iTypedRegionArray = this.computePartitioning(0, this.getDocument().getLength());
        int n = iTypedRegionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypedRegion region = iTypedRegionArray[n2];
            this.reconcile((IRegion)region);
            ++n2;
        }
    }

    public void reconcile(IRegion region) {
        if (this.getAnnotationModel() == null) {
            return;
        }
        try {
            this.currentRegion = region;
            if (region instanceof ITypedRegion && !this.contentTypes.contains(((ITypedRegion)region).getType())) {
                ISpellingProblemCollector collector = this.createSpellingProblemCollector();
                collector.beginCollecting();
                collector.endCollecting();
            } else {
                super.reconcile(region);
            }
        }
        finally {
            this.currentRegion = null;
        }
    }

    private String getDocumentPartitioning() {
        return this.documentPartitioning;
    }

    private ITypedRegion[] computePartitioning(int offset, int length) {
        ITypedRegion[] regions = null;
        try {
            regions = TextUtilities.computePartitioning((IDocument)this.getDocument(), (String)this.getDocumentPartitioning(), (int)offset, (int)length, (boolean)false);
        }
        catch (BadLocationException badLocationException) {
            regions = new TypedRegion[]{};
        }
        return regions;
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        private IAnnotationModel fAnnotationModel;
        private Map<Annotation, Position> fAddAnnotations;
        private Object fLockObject;

        public SpellingProblemCollector(IAnnotationModel annotationModel) {
            Assert.isLegal((annotationModel != null ? 1 : 0) != 0);
            this.fAnnotationModel = annotationModel;
            this.fLockObject = this.fAnnotationModel instanceof ISynchronizable ? ((ISynchronizable)this.fAnnotationModel).getLockObject() : this.fAnnotationModel;
        }

        public void accept(SpellingProblem problem) {
            this.fAddAnnotations.put((Annotation)new SpellingAnnotation(problem), new Position(problem.getOffset(), problem.getLength()));
        }

        public void beginCollecting() {
            this.fAddAnnotations = new HashMap<Annotation, Position>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endCollecting() {
            ArrayList<Annotation> toRemove = new ArrayList<Annotation>();
            Object object = this.fLockObject;
            synchronized (object) {
                Annotation annotation;
                Iterator iter;
                if (this.fAnnotationModel instanceof IAnnotationModelExtension2 && MultiRegionSpellingReconcileStrategy.this.currentRegion != null) {
                    iter = ((IAnnotationModelExtension2)this.fAnnotationModel).getAnnotationIterator(MultiRegionSpellingReconcileStrategy.this.currentRegion.getOffset(), MultiRegionSpellingReconcileStrategy.this.currentRegion.getLength(), true, true);
                    while (iter.hasNext()) {
                        annotation = (Annotation)iter.next();
                        if (!"org.eclipse.ui.workbench.texteditor.spelling".equals(annotation.getType())) continue;
                        toRemove.add(annotation);
                    }
                } else {
                    iter = this.fAnnotationModel.getAnnotationIterator();
                    while (iter.hasNext()) {
                        Position pos;
                        annotation = (Annotation)iter.next();
                        if (!"org.eclipse.ui.workbench.texteditor.spelling".equals(annotation.getType())) continue;
                        Position position = pos = MultiRegionSpellingReconcileStrategy.this.currentRegion != null ? this.fAnnotationModel.getPosition(annotation) : null;
                        if (MultiRegionSpellingReconcileStrategy.this.currentRegion != null && !pos.overlapsWith(MultiRegionSpellingReconcileStrategy.this.currentRegion.getOffset(), MultiRegionSpellingReconcileStrategy.this.currentRegion.getLength())) continue;
                        toRemove.add(annotation);
                    }
                }
                Annotation[] annotationsToRemove = toRemove.toArray(new Annotation[toRemove.size()]);
                if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(annotationsToRemove, this.fAddAnnotations);
                } else {
                    int i = 0;
                    while (i < annotationsToRemove.length) {
                        this.fAnnotationModel.removeAnnotation(annotationsToRemove[i]);
                        ++i;
                    }
                    for (Annotation annotation2 : this.fAddAnnotations.keySet()) {
                        this.fAnnotationModel.addAnnotation(annotation2, this.fAddAnnotations.get(annotation2));
                    }
                }
            }
            this.fAddAnnotations = null;
        }
    }
}

