/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.spelling;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.spelling.Messages;
import com.aptana.editor.common.spelling.ScopeDefinitions;
import com.aptana.editor.common.spelling.SpellingPreferences;
import java.util.Arrays;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class SpellingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String GENERAL_SPELLING_PREF_ID = "org.eclipse.ui.editors.preferencePages.Spelling";
    private CheckboxTableViewer tableViewer;
    private Link globalPreferencesLink;

    public SpellingPreferencePage() {
        this.setPreferenceStore(CommonEditorPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.globalPreferencesLink = new Link(composite, 0);
        this.globalPreferencesLink.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create());
        Label label = new Label(composite, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.SpellingPreferencePage_label));
        label.setLayoutData((Object)GridDataFactory.swtDefaults().indent(-1, 5).align(4, 0x1000000).create());
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.tableViewer.getTable().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ScopeDefinitions.DEFINITIONS.get(element);
            }
        });
        this.tableViewer.setInput(ScopeDefinitions.DEFINITIONS.keySet());
        this.tableViewer.setCheckedElements(SpellingPreferences.getEnabledScopes().toArray());
        this.globalPreferencesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IWorkbenchPreferenceContainer)SpellingPreferencePage.this.getContainer()).openPage(SpellingPreferencePage.GENERAL_SPELLING_PREF_ID, null);
            }
        });
        this.applyDialogFont(composite);
        this.updateStatus();
        return composite;
    }

    public void setContainer(IPreferencePageContainer container) {
        super.setContainer(container);
        this.updateStatus();
    }

    protected void performDefaults() {
        this.tableViewer.setCheckedElements(ScopeDefinitions.DEFINITIONS.keySet().toArray());
        super.performDefaults();
    }

    public boolean performOk() {
        Object[] checked = this.tableViewer.getCheckedElements();
        String[] scopes = new String[checked.length];
        System.arraycopy(checked, 0, scopes, 0, scopes.length);
        SpellingPreferences.setEnabledScopes(Arrays.asList(scopes));
        return super.performOk();
    }

    private void updateStatus() {
        boolean spellingEnabled = EditorsUI.getPreferenceStore().getBoolean("spellingEnabled");
        if (this.globalPreferencesLink != null) {
            String spellingEnabledMessage = Messages.SpellingPreferencePage_EnabledMessage;
            String spellingDisabledMessage = Messages.SpellingPreferencePage_DisabledMessage;
            this.globalPreferencesLink.setText(spellingEnabled ? spellingEnabledMessage : spellingDisabledMessage);
        }
        if (this.tableViewer != null) {
            this.tableViewer.getControl().setEnabled(spellingEnabled);
        }
    }
}

