/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class EditorSearchHyperlink
implements IHyperlink {
    private IRegion region;
    private URI document;
    private String searchString;

    public EditorSearchHyperlink(IRegion region, String searchString, URI document) {
        this.region = region;
        this.searchString = searchString;
        this.document = document;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return MessageFormat.format("Open in {0}", this.document.toString());
    }

    public void open() {
        try {
            IFileStore store = EFS.getStore((URI)this.document);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart part = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)store);
            IFindReplaceTarget target = (IFindReplaceTarget)part.getAdapter(IFindReplaceTarget.class);
            if (target != null && target.canPerformFind()) {
                target.findAndSelect(0, this.searchString, true, true, true);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }
}

