/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.reconciler;

import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.text.reconciler.CommonReconciler;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.LoadCycleListener;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class BundleChangeReconcileTrigger
implements LoadCycleListener {
    private static final String BUNDLE_RB = "bundle.rb";
    private final CommonReconciler reconciler;
    private final Job job = new Job("Force reconcile on bundle change"){

        protected IStatus run(IProgressMonitor monitor) {
            BundleChangeReconcileTrigger.this.reconciler.forceReconciling();
            return Status.OK_STATUS;
        }
    };

    public BundleChangeReconcileTrigger(CommonReconciler reconciler) {
        this.reconciler = reconciler;
        BundleManager.getInstance().addLoadCycleListener((LoadCycleListener)this);
    }

    public void dispose() {
        BundleManager.getInstance().removeLoadCycleListener((LoadCycleListener)this);
    }

    public void scriptLoaded(File script) {
        this.bundleFileChanged(script);
    }

    public void scriptReloaded(File script) {
        this.bundleFileChanged(script);
    }

    public void scriptUnloaded(File script) {
        this.bundleFileChanged(script);
    }

    private void bundleFileChanged(File script) {
        if (script == null || !script.getName().equals(BUNDLE_RB)) {
            return;
        }
        this.job.cancel();
        try {
            this.job.setSystem(!EclipseUtil.showSystemJobs());
        }
        catch (IllegalStateException illegalStateException) {}
        this.job.schedule(750L);
    }
}

