/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.reconciler;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.Regions;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.swt.custom.StyledText;

public class CommonPresentationReconciler
extends PresentationReconciler {
    private int iterationPartitionLimit = 4000;
    private int backgroundReconcileDelay = 2000;
    private int iterationDelay = 500;
    private int minimalVisibleLength = 20000;
    private ITextViewer textViewer;
    private Regions delayedRegions = new Regions();
    private IRegion viewerVisibleRegion;
    private Job job;

    public void install(ITextViewer viewer) {
        super.install(viewer);
        this.delayedRegions.clear();
        this.textViewer = viewer;
        this.iterationPartitionLimit = Integer.getInteger("studio.reconcilerIterationPartitionLimit", this.iterationPartitionLimit);
        this.backgroundReconcileDelay = Integer.getInteger("studio.reconcilerBackgroundDelay", this.backgroundReconcileDelay);
        this.iterationDelay = Integer.getInteger("studio.reconcilerIterationDelay", this.iterationDelay);
        this.minimalVisibleLength = Integer.getInteger("studio.reconcilerMinimalVisibleLength", this.minimalVisibleLength);
        if (IdeLog.isTraceEnabled((Plugin)CommonEditorPlugin.getDefault(), (String)"com.aptana.editor.common/debug/presentation")) {
            IdeLog.logTrace((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Reconciling process set for partition limit of {0} partitions, background delay of {1}ms, iteration delay of {2}ms, and minimal visible length of {3} lines", this.iterationPartitionLimit, this.backgroundReconcileDelay, this.iterationDelay, this.minimalVisibleLength), (String)"com.aptana.editor.common/debug/presentation");
        }
    }

    public void uninstall() {
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        this.delayedRegions.clear();
        this.textViewer = null;
        super.uninstall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TextPresentation createPresentation(IRegion damage, IDocument document) {
        if (IdeLog.isInfoEnabled((Plugin)CommonEditorPlugin.getDefault(), (String)"com.aptana.editor.common/debug/presentation")) {
            IdeLog.logInfo((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Initiating presentation reconciling for region at offset {0}, length {1} in document of length {2}", damage.getOffset(), damage.getLength(), document.getLength()), (String)"com.aptana.editor.common/debug/presentation");
        }
        CommonPresentationReconciler commonPresentationReconciler = this;
        synchronized (commonPresentationReconciler) {
            this.delayedRegions.append(damage);
        }
        try {
            TextPresentation textPresentation = this.createPresentation(this.nextDamagedRegion(), document, (IProgressMonitor)new NullProgressMonitor());
            return textPresentation;
        }
        finally {
            this.triggerDelayedCreatePresentation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TextPresentation createPresentation(IRegion damage, IDocument document, IProgressMonitor monitor) {
        try {
            int damageOffset = damage.getOffset();
            int damageLength = damage.getLength();
            if (damageOffset + damageLength > document.getLength()) {
                int adjustedLength = document.getLength() - damageOffset;
                CommonPresentationReconciler commonPresentationReconciler = this;
                synchronized (commonPresentationReconciler) {
                    this.delayedRegions.remove(new IRegion[]{new Region(document.getLength(), damageLength - adjustedLength)});
                }
                if (adjustedLength <= 0) {
                    return null;
                }
                damageLength = adjustedLength;
            }
            TextPresentation presentation = new TextPresentation(damage, this.iterationPartitionLimit * 5);
            ITypedRegion[] partitioning = TextUtilities.computePartitioning((IDocument)document, (String)this.getDocumentPartitioning(), (int)damageOffset, (int)damageLength, (boolean)false);
            if (partitioning.length == 0) {
                return presentation;
            }
            int limit = Math.min(this.iterationPartitionLimit, partitioning.length);
            int processingLength = partitioning[limit - 1].getOffset() + partitioning[limit - 1].getLength() - damageOffset;
            if (EclipseUtil.showSystemJobs()) {
                monitor.subTask(MessageFormat.format("processing region at offset {0}, length {1} in document of length {2}", damageOffset, processingLength, document.getLength()));
            }
            int i = 0;
            while (true) {
                if (i >= limit) {
                    CommonPresentationReconciler commonPresentationReconciler = this;
                    synchronized (commonPresentationReconciler) {
                        this.delayedRegions.remove(new IRegion[]{new Region(damageOffset, processingLength)});
                        if (limit >= partitioning.length) return presentation;
                        int offset = partitioning[limit].getOffset();
                        this.delayedRegions.append(new IRegion[]{new Region(offset, damageOffset + damageLength - offset)});
                        return presentation;
                    }
                }
                ITypedRegion r = partitioning[i];
                IPresentationRepairer repairer = this.getRepairer(r.getType());
                if (monitor.isCanceled()) {
                    return null;
                }
                if (repairer != null) {
                    repairer.createPresentation(presentation, r);
                }
                monitor.worked(r.getLength());
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected Theme getCurrentTheme() {
        return ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDamage(IRegion damage, IDocument document, IProgressMonitor monitor) {
        if (damage != null && damage.getLength() > 0) {
            final TextPresentation[] presentation = new TextPresentation[1];
            Object object = CommonPresentationReconciler.getLockObject(document);
            synchronized (object) {
                presentation[0] = this.createPresentation(damage, document, monitor);
            }
            if (presentation[0] != null) {
                UIUtils.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        ITextViewer viewer = CommonPresentationReconciler.this.textViewer;
                        if (viewer != null) {
                            StyledText widget = viewer.getTextWidget();
                            if (widget != null && !widget.isDisposed()) {
                                viewer.changeTextPresentation(presentation[0], true);
                            }
                            int topOffset = viewer.getTopIndexStartOffset();
                            int length = viewer.getBottomIndexEndOffset() - topOffset;
                            CommonPresentationReconciler.this.viewerVisibleRegion = (IRegion)new Region(topOffset, Math.max(length, CommonPresentationReconciler.this.minimalVisibleLength));
                        }
                    }
                });
            }
        }
    }

    private synchronized void triggerDelayedCreatePresentation() {
        if (this.job != null) {
            this.job.cancel();
        } else {
            this.job = new Job("Delayed Presentation Reconciler"){

                protected IStatus run(IProgressMonitor monitor) {
                    IDocument document;
                    int priority = Thread.currentThread().getPriority();
                    Thread.currentThread().setPriority(1);
                    IDocument iDocument = document = CommonPresentationReconciler.this.textViewer != null ? CommonPresentationReconciler.this.textViewer.getDocument() : null;
                    if (document == null) {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.beginTask("Reconciling document", document.getLength());
                    while (CommonPresentationReconciler.this.textViewer != null && !monitor.isCanceled()) {
                        IRegion damage = CommonPresentationReconciler.this.nextDamagedRegion();
                        if (damage == null || monitor.isCanceled() || CommonPresentationReconciler.this.textViewer == null) break;
                        CommonPresentationReconciler.this.processDamage(damage, CommonPresentationReconciler.this.textViewer.getDocument(), monitor);
                        try {
                            Thread.sleep(CommonPresentationReconciler.this.iterationDelay);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                    monitor.done();
                    Thread.currentThread().setPriority(priority);
                    return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                }
            };
            this.job.setPriority(50);
            this.job.setSystem(!EclipseUtil.showSystemJobs());
        }
        if (!this.delayedRegions.isEmpty()) {
            this.job.schedule((long)this.backgroundReconcileDelay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRegion nextDamagedRegion() {
        if (this.viewerVisibleRegion == null && this.textViewer != null) {
            UIUtils.getDisplay().syncExec(new Runnable(){

                public void run() {
                    ITextViewer viewer = CommonPresentationReconciler.this.textViewer;
                    if (viewer == null) {
                        return;
                    }
                    int topOffset = viewer.getTopIndexStartOffset();
                    int length = viewer.getBottomIndexEndOffset() - topOffset;
                    CommonPresentationReconciler.this.viewerVisibleRegion = (IRegion)new Region(topOffset, Math.max(length, CommonPresentationReconciler.this.minimalVisibleLength));
                }
            });
        }
        CommonPresentationReconciler commonPresentationReconciler = this;
        synchronized (commonPresentationReconciler) {
            block7: {
                if (!this.delayedRegions.isEmpty()) break block7;
                return null;
            }
            if (this.viewerVisibleRegion != null) {
                IRegion visible = this.delayedRegions.overlap(this.viewerVisibleRegion);
                this.viewerVisibleRegion = null;
                if (visible != null) {
                    return visible;
                }
            }
            return this.delayedRegions.iterator().next();
        }
    }

    private static Object getLockObject(Object object) {
        Object lock;
        if (object instanceof ISynchronizable && (lock = ((ISynchronizable)object).getLockObject()) != null) {
            return lock;
        }
        return object;
    }
}

