/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.reconciler;

import com.aptana.editor.common.text.reconciler.BundleChangeReconcileTrigger;
import com.aptana.editor.common.text.reconciler.IBatchReconcilingStrategy;
import com.aptana.editor.common.text.reconciler.IDisposableReconcilingStrategy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.reconciler.Reconciler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonReconciler
extends Reconciler {
    private IReconcilingStrategy defaultStrategy;
    private final Set<IReconcilingStrategy> reconcilingStrategies = new HashSet<IReconcilingStrategy>();
    private BundleChangeReconcileTrigger bundleChangeReconcileTrigger;
    private boolean fInitialProcessDone = false;

    public CommonReconciler(IReconcilingStrategy defaultStrategy) {
        this.defaultStrategy = defaultStrategy;
        this.setReconcilingStrategy(defaultStrategy, String.valueOf(System.currentTimeMillis()));
    }

    public void dispose() {
        if (this.defaultStrategy instanceof IDisposableReconcilingStrategy) {
            ((IDisposableReconcilingStrategy)this.defaultStrategy).dispose();
        }
        this.defaultStrategy = null;
    }

    public void setReconcilingStrategy(IReconcilingStrategy strategy, String contentType) {
        super.setReconcilingStrategy(strategy, contentType);
        this.reconcilingStrategies.add(strategy);
    }

    public void setReconcilingStrategy(IReconcilingStrategy strategy, Collection<String> contentTypes) {
        for (String contentType : contentTypes) {
            this.setReconcilingStrategy(strategy, contentType);
        }
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        IReconcilingStrategy strategy = super.getReconcilingStrategy(contentType);
        if (strategy != null) {
            return strategy;
        }
        return this.defaultStrategy;
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.bundleChangeReconcileTrigger = new BundleChangeReconcileTrigger(this);
    }

    public void uninstall() {
        if (this.bundleChangeReconcileTrigger != null) {
            this.bundleChangeReconcileTrigger.dispose();
            this.bundleChangeReconcileTrigger = null;
        }
        super.uninstall();
    }

    protected void process(DirtyRegion dirtyRegion) {
        DirtyRegion region = dirtyRegion;
        if (region == null) {
            region = new Region(0, this.getDocument().getLength());
        }
        HashSet<IBatchReconcilingStrategy> batch = new HashSet<IBatchReconcilingStrategy>();
        ITypedRegion[] regions = this.computePartitioning(region.getOffset(), region.getLength());
        int i = 0;
        while (i < regions.length) {
            ITypedRegion r = regions[i];
            IReconcilingStrategy s = this.getReconcilingStrategy(r.getType());
            if (s != null) {
                if (s instanceof IBatchReconcilingStrategy) {
                    batch.add((IBatchReconcilingStrategy)s);
                }
                if (dirtyRegion != null) {
                    s.reconcile(dirtyRegion, (IRegion)r);
                } else {
                    s.reconcile((IRegion)r);
                }
            }
            ++i;
        }
        for (IBatchReconcilingStrategy batcher : batch) {
            batcher.fullReconcile();
        }
    }

    protected ITypedRegion[] computePartitioning(int offset, int length) {
        ITypedRegion[] regions = null;
        try {
            regions = TextUtilities.computePartitioning((IDocument)this.getDocument(), (String)this.getDocumentPartitioning(), (int)offset, (int)length, (boolean)false);
        }
        catch (BadLocationException badLocationException) {
            regions = new TypedRegion[]{};
        }
        return regions;
    }

    protected void initialProcess() {
        for (IReconcilingStrategy s : this.reconcilingStrategies) {
            if (!(s instanceof IReconcilingStrategyExtension)) continue;
            ((IReconcilingStrategyExtension)s).initialReconcile();
        }
        this.fInitialProcessDone = true;
    }

    public void forceReconciling() {
        super.forceReconciling();
    }
}

