/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.reconciler;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.IFilter;
import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.build.IBuildParticipantManager;
import com.aptana.core.build.ReconcileContext;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.ICommonAnnotationModel;
import com.aptana.editor.common.text.reconciler.IBatchReconcilingStrategy;
import com.aptana.editor.common.text.reconciler.IDisposableReconcilingStrategy;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ast.IParseRootNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.texteditor.IDocumentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IBatchReconcilingStrategy,
IDisposableReconcilingStrategy {
    private AbstractThemeableEditor fEditor;
    private IDocument fDocument;
    private boolean fInitialReconcileDone;
    private IProgressMonitor fMonitor;
    private IFoldingComputer folder;
    private Map<ProjectionAnnotation, Position> fPositions = new HashMap<ProjectionAnnotation, Position>();
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 258) {
                CommonReconcilingStrategy.this.reconcile(false, true);
            }
        }
    };

    public CommonReconcilingStrategy(AbstractThemeableEditor editor) {
        this.fEditor = editor;
        this.fEditor.addPropertyListener(this.propertyListener);
    }

    @Override
    public void dispose() {
        if (this.fEditor != null) {
            this.fEditor.removePropertyListener(this.propertyListener);
            this.fEditor = null;
        }
        this.fPositions.clear();
    }

    protected AbstractThemeableEditor getEditor() {
        return this.fEditor;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    public void reconcile(IRegion partition) {
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
    }

    public void setDocument(IDocument document) {
        this.folder = this.createFoldingComputer(document);
        this.fDocument = document;
    }

    protected IFoldingComputer createFoldingComputer(IDocument document) {
        return this.fEditor.createFoldingComputer(document);
    }

    public void initialReconcile() {
        if (this.fInitialReconcileDone) {
            return;
        }
        this.reconcile(true);
        this.fInitialReconcileDone = true;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fMonitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculatePositions(boolean initialReconcile, IProgressMonitor monitor, IParseRootNode ast) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        try {
            Map<ProjectionAnnotation, Position> map = this.fPositions;
            synchronized (map) {
                this.fPositions.clear();
                this.fPositions = this.folder.emitFoldingRegions(initialReconcile, monitor, ast);
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        if (monitor != null && monitor.isCanceled() || !this.shouldUpdatePositions(this.folder)) {
            return;
        }
        this.updatePositions();
    }

    protected boolean shouldUpdatePositions(IFoldingComputer folder) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearPositions(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        Map<ProjectionAnnotation, Position> map = this.fPositions;
        synchronized (map) {
            this.fPositions.clear();
        }
    }

    protected void updatePositions() {
        if (this.fEditor != null) {
            this.fEditor.updateFoldingStructure(this.fPositions);
        }
    }

    private void reconcile(boolean initialReconcile) {
        this.reconcile(initialReconcile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcile(boolean initialReconcile, boolean force) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)this.fMonitor, (int)100);
        IParseRootNode ast = null;
        if (this.fEditor != null) {
            ast = this.fEditor.getAST();
            this.fEditor.refreshOutline(ast);
        }
        monitor.worked(5);
        if (this.fEditor != null && this.fEditor.isFoldingEnabled()) {
            this.calculatePositions(initialReconcile, (IProgressMonitor)monitor.newChild(20), ast);
        } else {
            Map<ProjectionAnnotation, Position> map = this.fPositions;
            synchronized (map) {
                this.fPositions.clear();
            }
            this.updatePositions();
        }
        monitor.setWorkRemaining(75);
        if (monitor.isCanceled()) {
            return;
        }
        this.runParticipants((IProgressMonitor)monitor.newChild(75));
    }

    private void runParticipants(IProgressMonitor monitor) {
        IFile file = this.getFile();
        if (file != null && ResourceUtil.shouldIgnore((IFile)file)) {
            return;
        }
        List<IBuildParticipant> participants = this.getBuildParticipantManager().getBuildParticipants(this.fEditor.getContentType());
        if (CollectionsUtil.isEmpty((Collection)participants)) {
            return;
        }
        if (CollectionsUtil.isEmpty(participants = this.filterToEnabled(participants))) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(participants.size() * 12 + 10));
        ReconcileContext context = this.createContext();
        for (IBuildParticipant participant : participants) {
            participant.buildStarting(context.getProject(), 10, (IProgressMonitor)sub.newChild(1));
        }
        for (IBuildParticipant participant : participants) {
            participant.buildFile((BuildContext)context, (IProgressMonitor)sub.newChild(10));
        }
        for (IBuildParticipant participant : participants) {
            participant.buildEnding((IProgressMonitor)sub.newChild(1));
        }
        this.reportProblems(context, (IProgressMonitor)sub.newChild(10));
        sub.done();
    }

    protected IBuildParticipantManager getBuildParticipantManager() {
        return BuildPathCorePlugin.getDefault().getBuildParticipantManager();
    }

    protected ReconcileContext createContext() {
        IFile file = this.getFile();
        if (file != null) {
            return new ReconcileContext(this.fEditor.getContentType(), file, this.fDocument.get());
        }
        return new ReconcileContext(this.fEditor.getContentType(), EditorUtil.getURI((IEditorPart)this.fEditor), this.fDocument.get());
    }

    private List<IBuildParticipant> filterToEnabled(List<IBuildParticipant> participants) {
        return CollectionsUtil.filter(participants, (IFilter)new IFilter<IBuildParticipant>(){

            public boolean include(IBuildParticipant item) {
                return item != null && item.isEnabled(IBuildParticipant.BuildType.RECONCILE);
            }
        });
    }

    private void reportProblems(ReconcileContext context, IProgressMonitor monitor) {
        if (this.fEditor == null) {
            return;
        }
        IDocumentProvider docProvider = this.fEditor.getDocumentProvider();
        if (docProvider == null) {
            return;
        }
        IEditorInput editorInput = this.fEditor.getEditorInput();
        if (editorInput == null) {
            return;
        }
        IAnnotationModel model = docProvider.getAnnotationModel((Object)editorInput);
        if (!(model instanceof ICommonAnnotationModel)) {
            return;
        }
        ICommonAnnotationModel caModel = (ICommonAnnotationModel)model;
        caModel.reportProblems(context.getProblems(), monitor);
    }

    protected IFile getFile() {
        IEditorInput editorInput;
        if (this.fEditor != null && (editorInput = this.fEditor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return fileEditorInput.getFile();
        }
        return null;
    }

    @Override
    public void fullReconcile() {
        this.reconcile(false);
    }
}

