/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.rules;

import com.aptana.editor.common.IPartitionScannerSwitchStrategy;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.SequenceCharacterScanner;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;

public abstract class CompositeSubPartitionScanner
implements ISubPartitionScanner {
    protected static final int TYPE_DEFAULT = 0;
    protected ISubPartitionScanner[] subPartitionScanners;
    protected IPartitionScannerSwitchStrategy[] switchStrategies;
    protected SequenceCharacterScanner[] sequenceCharacterScanners;
    protected SequenceCharacterScanner parentSequenceCharacterScanner;
    protected int current = 0;
    private IToken lastToken;
    protected IToken resumeToken;

    protected CompositeSubPartitionScanner(ISubPartitionScanner[] subPartitionScanners, IPartitionScannerSwitchStrategy[] switchStrategies) {
        this.subPartitionScanners = subPartitionScanners;
        this.switchStrategies = switchStrategies;
    }

    public void initCharacterScanner(ICharacterScanner baseCharacterScanner, IPartitionScannerSwitchStrategy switchStrategy) {
        this.parentSequenceCharacterScanner = new SequenceCharacterScanner(baseCharacterScanner, switchStrategy, true);
        this.sequenceCharacterScanners = new SequenceCharacterScanner[this.subPartitionScanners.length];
        this.sequenceCharacterScanners[0] = this.parentSequenceCharacterScanner;
        int i = 0;
        while (i < this.switchStrategies.length) {
            this.sequenceCharacterScanners[1 + i] = new SequenceCharacterScanner(this.parentSequenceCharacterScanner, this.switchStrategies[i], true);
            ++i;
        }
    }

    public IPredicateRule[] getRules() {
        return this.subPartitionScanners[this.current].getRules();
    }

    public IToken getDefaultToken() {
        return this.subPartitionScanners[this.current].getDefaultToken();
    }

    public ICharacterScanner getCharacterScanner() {
        return this.sequenceCharacterScanners[this.current];
    }

    public boolean foundSequence() {
        return this.parentSequenceCharacterScanner.foundSequence();
    }

    protected boolean foundSequence(boolean reset) {
        return this.parentSequenceCharacterScanner.foundSequence(reset);
    }

    public boolean doResetRules() {
        if (this.current != 0 && this.sequenceCharacterScanners[this.current].foundSequence()) {
            this.current = 0;
            return true;
        }
        return false;
    }

    public boolean hasContentType(String contentType) {
        ISubPartitionScanner[] iSubPartitionScannerArray = this.subPartitionScanners;
        int n = this.subPartitionScanners.length;
        int n2 = 0;
        while (n2 < n) {
            ISubPartitionScanner i = iSubPartitionScannerArray[n2];
            if (i.hasContentType(contentType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setLastToken(IToken token) {
        this.lastToken = this.foundSequence(false) ? token : null;
    }

    public final IToken getLastToken() {
        return this.lastToken;
    }

    public IToken getResumeToken() {
        try {
            IToken iToken = this.resumeToken;
            return iToken;
        }
        finally {
            this.resumeToken = null;
        }
    }
}

