/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class MultiCharacterRule
implements IPredicateRule {
    private IToken successToken;
    private char[] sequence;

    public MultiCharacterRule(String sequence, IToken successToken) {
        this(sequence.toCharArray(), successToken);
    }

    public MultiCharacterRule(char[] sequence, IToken successToken) {
        this.sequence = sequence;
        this.successToken = successToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int index = 0;
        char[] cArray = this.sequence;
        int n = this.sequence.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            ++index;
            if (c != scanner.read()) {
                int j = index;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
                return Token.UNDEFINED;
            }
            ++n2;
        }
        return this.getSuccessToken();
    }

    public IToken getSuccessToken() {
        return this.successToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }
}

