/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.util;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class EditorUtil {
    protected static final int DEFAULT_SPACE_INDENT_SIZE = 2;

    public static int getSpaceIndentSize() {
        IEditorPart activeEditor = UIUtils.getActiveEditor();
        if (activeEditor != null) {
            return EditorUtil.getSpaceIndentSize(activeEditor.getSite().getId());
        }
        return EditorUtil.getSpaceIndentSize(null);
    }

    public static int getSpaceIndentSize(String preferencesQualifier) {
        int spaceIndentSize = 0;
        if (preferencesQualifier != null) {
            spaceIndentSize = Platform.getPreferencesService().getInt(preferencesQualifier, "tabWidth", 0, null);
        }
        return spaceIndentSize > 0 ? spaceIndentSize : EditorUtil.getDefaultSpaceIndentSize(preferencesQualifier);
    }

    public static int getDefaultSpaceIndentSize(String preferencesQualifier) {
        int spaceIndentSize = 0;
        if (CommonEditorPlugin.getDefault() != null && EditorsPlugin.getDefault() != null) {
            spaceIndentSize = new ChainedPreferenceStore(new IPreferenceStore[]{CommonEditorPlugin.getDefault().getPreferenceStore(), EditorsPlugin.getDefault().getPreferenceStore()}).getInt("tabWidth");
        }
        return spaceIndentSize > 0 ? spaceIndentSize : 2;
    }

    public static String convertIndent(String indent, int indentSize, boolean useTabs) {
        if (indent == null) {
            return "";
        }
        if (useTabs && indent.contains(" ")) {
            String newIndent = "";
            int spacesCount = indent.replaceAll("\t", "").length();
            int i = 0;
            while (i < indent.length() - spacesCount + spacesCount / indentSize) {
                newIndent = String.valueOf(newIndent) + '\t';
                ++i;
            }
            i = 0;
            while (i < spacesCount % indentSize) {
                newIndent = String.valueOf(newIndent) + ' ';
                ++i;
            }
            return newIndent;
        }
        if (!useTabs && indent.contains("\t")) {
            String newIndent = "";
            int tabCount = indent.replaceAll(" ", "").length();
            int i = 0;
            while (i < indent.length() - tabCount + tabCount * indentSize) {
                newIndent = String.valueOf(newIndent) + " ";
                ++i;
            }
            return newIndent;
        }
        return indent;
    }

    public static IEditorDescriptor getEditorDescriptor(URI uri) {
        String uriPath = uri.getPath();
        if (StringUtil.isEmpty((String)uriPath) || uriPath.equals("/")) {
            return null;
        }
        Path path = new Path(uriPath);
        return PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(path.lastSegment());
    }

    public static Index getIndex(AbstractThemeableEditor editor) {
        if (editor != null) {
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                IFile file = fileEditorInput.getFile();
                return EditorUtil.getIndexManager().getIndex(file.getProject().getLocationURI());
            }
            if (editorInput instanceof IURIEditorInput) {
                IURIEditorInput uriEditorInput = (IURIEditorInput)editorInput;
                return EditorUtil.getIndexManager().getIndex(uriEditorInput.getURI());
            }
            if (editorInput instanceof IPathEditorInput) {
                IPathEditorInput pathEditorInput = (IPathEditorInput)editorInput;
                return EditorUtil.getIndexManager().getIndex(URIUtil.toURI((IPath)pathEditorInput.getPath()));
            }
        }
        return null;
    }

    protected static IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    public static URI getURI(IEditorPart editor) {
        if (editor != null) {
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof IURIEditorInput) {
                IURIEditorInput uriEditorInput = (IURIEditorInput)editorInput;
                return uriEditorInput.getURI();
            }
            if (editorInput instanceof IPathEditorInput) {
                IPathEditorInput pathEditorInput = (IPathEditorInput)editorInput;
                return URIUtil.toURI((IPath)pathEditorInput.getPath());
            }
            if (editorInput instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                return fileEditorInput.getFile().getLocationURI();
            }
        }
        return null;
    }

    public static IEditorPart openInEditor(File file) {
        if (file == null) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)"Error open a file in the editor", (Throwable)new IllegalArgumentException("file is null"));
            return null;
        }
        try {
            URI uri = file.toURI();
            IEditorDescriptor desc = EditorUtil.getEditorDescriptor(uri);
            String editorId = desc == null ? "org.eclipse.ui.systemExternalEditor" : desc.getId();
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return IDE.openEditor((IWorkbenchPage)page, (URI)uri, (String)editorId, (boolean)true);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)"Error open a file in the editor", (Throwable)e);
            return null;
        }
    }

    public static IProject getProject(AbstractThemeableEditor editor) {
        IEditorInput editorInput;
        if (editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return fileEditorInput.getFile().getProject();
        }
        return null;
    }

    public static URI getProjectURI(AbstractThemeableEditor editor) {
        IProject project = EditorUtil.getProject(editor);
        return project == null ? null : project.getLocationURI();
    }
}

