/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.debug.ui;

import com.aptana.core.logging.IdeLog;
import com.aptana.ruby.debug.core.IRubyLineBreakpoint;
import com.aptana.ruby.debug.core.RubyDebugModel;
import com.aptana.ruby.debug.ui.RubyDebugUIPlugin;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyLineBreakpointAdapter
implements IToggleBreakpointsTarget {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IFileStore store = this.getFileStore(part);
        if (store == null) {
            return;
        }
        URI uri = store.toURI();
        IWorkspaceRoot resource = null;
        IPath fileName = null;
        if ("file".equals(uri.getScheme())) {
            File file = new File(uri);
            fileName = Path.fromOSString((String)file.getAbsolutePath());
            resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(fileName);
        }
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        } else {
            fileName = resource.getProjectRelativePath();
        }
        if (IdeLog.isTraceEnabled((Plugin)RubyDebugUIPlugin.getDefault(), null)) {
            IdeLog.logTrace((Plugin)RubyDebugUIPlugin.getDefault(), (String)MessageFormat.format("Toggling breakpoint for URI: {0}, filename: {1}. Marker being set on resource: {2}", uri.toString(), fileName, resource.getLocation().toOSString()));
        }
        ITextSelection textSelection = (ITextSelection)selection;
        int lineNumber = textSelection.getStartLine();
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("com.aptana.ruby.debug");
        int i = 0;
        while (i < breakpoints.length) {
            IRubyLineBreakpoint rubyLineBreakpoint;
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof IRubyLineBreakpoint && (rubyLineBreakpoint = (IRubyLineBreakpoint)breakpoint).getFilePath().equals((Object)fileName) && rubyLineBreakpoint.getLineNumber() == lineNumber + 1) {
                breakpoint.delete();
                return;
            }
            ++i;
        }
        RubyDebugModel.createLineBreakpoint((IResource)resource, (IPath)fileName, (String)"", (int)(++lineNumber), (boolean)true, null);
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.getFileStore(part) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IFileStore getFileStore(IWorkbenchPart part) {
        if (!(part instanceof ITextEditor)) {
            return null;
        }
        try {
            String contentType;
            IStorageEditorInput storageInput;
            IPath path;
            ITextEditor editorPart = (ITextEditor)part;
            IEditorInput editorInput = editorPart.getEditorInput();
            IFileStore store = null;
            if (editorInput instanceof IURIEditorInput) {
                IURIEditorInput uriInput = (IURIEditorInput)editorInput;
                store = EFS.getStore((URI)uriInput.getURI());
            } else if (editorInput instanceof IStorageEditorInput && (path = (storageInput = (IStorageEditorInput)editorInput).getStorage().getFullPath()) != null) {
                File file = path.toFile();
                if (!file.exists()) {
                    IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                    IPath location = iFile.getLocation();
                    if (location == null) {
                        return null;
                    }
                    file = location.toFile();
                }
                store = EFS.getStore((URI)file.toURI());
            }
            if (store == null) {
                return null;
            }
            Iterator<String> iterator = this.getValidContentTypes().iterator();
            do {
                if (!iterator.hasNext()) {
                    return null;
                }
                contentType = iterator.next();
            } while (!this.isAssociatedWith(store.getName(), contentType));
            return store;
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    protected Set<String> getValidContentTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add("com.aptana.contenttype.ruby");
        set.add("com.aptana.contenttype.ruby.ambiguous");
        set.add("com.aptana.contenttype.html.erb");
        return set;
    }

    private boolean isAssociatedWith(String fileName, String contentTypeId) {
        IContentType targetType = Platform.getContentTypeManager().getContentType(contentTypeId);
        return targetType.isAssociatedWith(fileName);
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

