/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.ui.breakpoints;

import com.aptana.ruby.debug.core.IRubyBreakpoint;
import com.aptana.ruby.debug.ui.RubyDebugUIPlugin;
import com.aptana.ruby.internal.debug.ui.breakpoints.AbstractRubyBreakpointEditor;
import com.aptana.ruby.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class StandardRubyBreakpointEditor
extends AbstractRubyBreakpointEditor {
    private IRubyBreakpoint fBreakpoint;
    private Button fHitCountButton;
    private Text fHitCountText;
    public static final int PROP_HIT_COUNT_ENABLED = 4101;
    public static final int PROP_HIT_COUNT = 4102;

    public Control createControl(Composite parent) {
        return this.createStandardControls(parent);
    }

    protected Control createStandardControls(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)4, (int)1, (int)0, (int)0, (int)0);
        this.fHitCountButton = SWTFactory.createCheckButton((Composite)composite, (String)this.processMnemonics(PropertyPageMessages.RubyBreakpointPage_4), null, (boolean)false, (int)1);
        this.fHitCountButton.setLayoutData((Object)new GridData());
        this.fHitCountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean enabled = StandardRubyBreakpointEditor.this.fHitCountButton.getSelection();
                StandardRubyBreakpointEditor.this.fHitCountText.setEnabled(enabled);
                if (enabled) {
                    StandardRubyBreakpointEditor.this.fHitCountText.setFocus();
                }
                StandardRubyBreakpointEditor.this.setDirty(4101);
            }
        });
        this.fHitCountText = SWTFactory.createSingleText((Composite)composite, (int)1);
        GridData gd = (GridData)this.fHitCountText.getLayoutData();
        gd.minimumWidth = 50;
        this.fHitCountText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StandardRubyBreakpointEditor.this.setDirty(4102);
            }
        });
        SWTFactory.createLabel((Composite)composite, (String)"", (int)1);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StandardRubyBreakpointEditor.this.dispose();
            }
        });
        return composite;
    }

    public void setInput(Object breakpoint) throws CoreException {
        if (breakpoint instanceof IRubyBreakpoint) {
            this.setBreakpoint((IRubyBreakpoint)breakpoint);
        } else {
            this.setBreakpoint(null);
        }
    }

    public Object getInput() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(IRubyBreakpoint breakpoint) throws CoreException {
        this.fBreakpoint = breakpoint;
        boolean enabled = false;
        boolean hasHitCount = false;
        String text = "";
        if (breakpoint != null) {
            enabled = true;
            int hitCount = breakpoint.getHitCount();
            if (hitCount > 0) {
                text = new Integer(hitCount).toString();
                hasHitCount = true;
            }
        }
        this.fHitCountButton.setEnabled(enabled);
        this.fHitCountButton.setSelection(enabled & hasHitCount);
        this.fHitCountText.setEnabled(hasHitCount);
        this.fHitCountText.setText(text);
        this.setDirty(false);
    }

    protected IRubyBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    public void setFocus() {
    }

    public void doSave() throws CoreException {
        if (this.fBreakpoint != null) {
            int hitCount = -1;
            if (this.fHitCountButton.getSelection()) {
                try {
                    hitCount = Integer.parseInt(this.fHitCountText.getText());
                }
                catch (NumberFormatException e) {
                    throw new CoreException((IStatus)new Status(4, RubyDebugUIPlugin.getUniqueIdentifier(), 4, PropertyPageMessages.RubyBreakpointPage_0, (Throwable)e));
                }
            }
            this.fBreakpoint.setHitCount(hitCount);
        }
        this.setDirty(false);
    }

    public IStatus getStatus() {
        if (this.fHitCountButton.getSelection()) {
            String hitCountText = this.fHitCountText.getText();
            int hitCount = -1;
            try {
                hitCount = Integer.parseInt(hitCountText);
            }
            catch (NumberFormatException numberFormatException) {
                return new Status(4, RubyDebugUIPlugin.getUniqueIdentifier(), 4, PropertyPageMessages.RubyBreakpointPage_0, null);
            }
            if (hitCount < 1) {
                return new Status(4, RubyDebugUIPlugin.getUniqueIdentifier(), 4, PropertyPageMessages.RubyBreakpointPage_0, null);
            }
        }
        return Status.OK_STATUS;
    }

    protected Button createSusupendPropertyEditor(Composite parent, String text, final int propId) {
        Button button = new Button(parent, 32);
        button.setFont(parent.getFont());
        button.setText(text);
        GridData gd = new GridData(1);
        button.setLayoutData((Object)gd);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StandardRubyBreakpointEditor.this.setDirty(propId);
            }
        });
        return button;
    }
}

