/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.ui.display;

import com.aptana.core.logging.IdeLog;
import com.aptana.ruby.debug.ui.RubyDebugUIPlugin;
import com.aptana.ruby.internal.debug.ui.display.IDataDisplay;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;

class DataDisplay
implements IDataDisplay {
    private ITextViewer fTextViewer;

    public DataDisplay(ITextViewer viewer) {
        this.fTextViewer = viewer;
    }

    public void clear() {
        IDocument document = this.getTextViewer().getDocument();
        if (document != null) {
            document.set("");
        }
    }

    public void displayExpression(String expression) {
        IDocument document = this.fTextViewer.getDocument();
        int offset = document.getLength();
        try {
            if (offset != document.getLineInformationOfOffset(offset).getOffset()) {
                expression = String.valueOf(System.getProperty("line.separator")) + expression.trim();
            }
            document.replace(offset, 0, expression);
            this.fTextViewer.setSelectedRange(offset + expression.length(), 0);
            this.fTextViewer.revealRange(offset, expression.length());
        }
        catch (BadLocationException ble) {
            IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (Throwable)ble);
        }
    }

    public void displayExpressionValue(String value) {
        value = String.valueOf(System.getProperty("line.separator")) + '\t' + value;
        ITextSelection selection = (ITextSelection)this.fTextViewer.getSelectionProvider().getSelection();
        int offset = selection.getOffset() + selection.getLength();
        int length = value.length();
        try {
            this.fTextViewer.getDocument().replace(offset, 0, value);
        }
        catch (BadLocationException ble) {
            IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (Throwable)ble);
        }
        this.fTextViewer.setSelectedRange(offset + length, 0);
        this.fTextViewer.revealRange(offset, length);
    }

    private ITextViewer getTextViewer() {
        return this.fTextViewer;
    }
}

