/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.ui.display;

import com.aptana.core.logging.IdeLog;
import com.aptana.ruby.debug.core.model.IEvaluationResult;
import com.aptana.ruby.debug.core.model.IRubyStackFrame;
import com.aptana.ruby.debug.core.model.IRubyValue;
import com.aptana.ruby.debug.ui.RubyDebugUIPlugin;
import com.aptana.ruby.internal.debug.ui.display.IDataDisplay;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExecuteHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow win;
        IRubyStackFrame stackFrame;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        String expressionText = null;
        if (selection instanceof ITextSelection) {
            ITextSelection ts = (ITextSelection)selection;
            expressionText = ts.getText();
        }
        if ((stackFrame = ExecuteHandler.getEvaluationContext(win = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event))).isSuspended()) {
            IEvaluationResult result = stackFrame.evaluate(expressionText);
            this.displayResult(result, event);
        }
        return null;
    }

    protected void displayResult(final IEvaluationResult result, final ExecutionEvent event) {
        final Display display = UIUtils.getDisplay();
        if (result.hasErrors()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (display.isDisposed()) {
                        return;
                    }
                    ExecuteHandler.this.reportErrors(result);
                }
            });
        } else {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (display.isDisposed()) {
                        return;
                    }
                    IValue value = result.getValue();
                    IDataDisplay dataDisplay = ExecuteHandler.this.getDataDisplay(event);
                    if (dataDisplay != null) {
                        try {
                            dataDisplay.displayExpressionValue(ExecuteHandler.valueToCode(value));
                        }
                        catch (DebugException e) {
                            IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    private IDataDisplay getDataDisplay(ExecutionEvent event) {
        IDataDisplay display;
        IWorkbenchPart activePart;
        IDataDisplay display2;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part != null && (display2 = (IDataDisplay)part.getAdapter(IDataDisplay.class)) != null) {
            IWorkbenchPart activePart2;
            IWorkbenchPage page = UIUtils.getActivePage();
            if (page != null && (activePart2 = page.getActivePart()) != null && activePart2 != part) {
                page.activate(part);
            }
            return display2;
        }
        IWorkbenchPage page = UIUtils.getActivePage();
        if (page != null && (activePart = page.getActivePart()) != null && (display = (IDataDisplay)activePart.getAdapter(IDataDisplay.class)) != null) {
            return display;
        }
        return null;
    }

    private void reportErrors(IEvaluationResult result) {
    }

    static String valueToCode(IValue value) throws DebugException {
        StringBuilder buffer = new StringBuilder("# => ");
        String string = value.getValueString();
        if (value instanceof IRubyValue) {
            IRubyValue rubyValue = (IRubyValue)value;
            if ("Array".equals(value.getReferenceTypeName())) {
                buffer.append("[");
                IVariable[] vars = rubyValue.getVariables();
                int i = 0;
                while (i < vars.length) {
                    buffer.append(vars[i].getValue().getValueString());
                    if (i < vars.length - 1) {
                        buffer.append(", ");
                    }
                    ++i;
                }
                buffer.append("]");
            } else if ("Hash".equals(value.getReferenceTypeName())) {
                buffer.append("{");
                IVariable[] vars = rubyValue.getVariables();
                int i = 0;
                while (i < vars.length) {
                    buffer.append(vars[i]);
                    if (i < vars.length - 1) {
                        buffer.append(", ");
                    }
                    ++i;
                }
                buffer.append("}");
            }
        }
        buffer.append(string);
        return buffer.toString();
    }

    static IRubyStackFrame getEvaluationContext(IWorkbenchWindow workbenchWindow) {
        IStructuredSelection structured;
        Object first;
        IDebugContextService service = DebugUITools.getDebugContextManager().getContextService(workbenchWindow);
        ISelection sel = service.getActiveContext();
        if (sel instanceof IStructuredSelection && (first = (structured = (IStructuredSelection)sel).getFirstElement()) instanceof IRubyStackFrame) {
            return (IRubyStackFrame)first;
        }
        return null;
    }
}

