/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.internal;

import com.aptana.deploy.IDeployProvider;
import com.aptana.deploy.internal.DeployProviderRegistry;
import com.aptana.deploy.preferences.DeployPreferenceUtil;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;

public class ProjectPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IResource resource = ProjectPropertyTester.getResource(receiver);
        if (resource != null) {
            IContainer container = receiver instanceof IContainer ? (IContainer)resource : resource.getParent();
            if (!container.isAccessible()) {
                return false;
            }
            if ("isDeployable".equals(property)) {
                String id = DeployPreferenceUtil.getDeployProviderId(container);
                if (id != null) {
                    return true;
                }
                return DeployProviderRegistry.getInstance().getProvider(container) != null;
            }
            if ("isDeployType".equals(property)) {
                String id = DeployPreferenceUtil.getDeployProviderId(container);
                String arg = (String)expectedValue;
                if (id != null) {
                    return arg.equals(id);
                }
                IDeployProvider provider = DeployProviderRegistry.getInstance().getProviderById(arg);
                return provider != null && provider.handles(container);
            }
        }
        return false;
    }

    private static IResource getResource(Object receiver) {
        if (receiver instanceof IResource) {
            return (IResource)receiver;
        }
        if (receiver instanceof IAdaptable) {
            return (IResource)((IAdaptable)receiver).getAdapter(IResource.class);
        }
        return null;
    }
}

