/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.commands;

import com.aptana.core.logging.IdeLog;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.IServerManager;
import com.aptana.webserver.core.WebServerCorePlugin;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.radrails.rails.internal.RailsServer;
import org.radrails.rails.internal.ui.commands.AbstractRailsHandler;
import org.radrails.rails.ui.RailsUIPlugin;

public class RunServerHandler
extends AbstractRailsHandler {
    protected String getMode() {
        return "run";
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject railsProject = this.getProject(event);
        if (railsProject == null) {
            return null;
        }
        RailsServer server = this.findOrCreateServer(railsProject);
        if (server == null) {
            return null;
        }
        String mode = this.getMode();
        if (server.getState() == IServer.State.STARTED) {
            if (mode.equals(server.getMode())) {
                server.restart(mode, (IProgressMonitor)new NullProgressMonitor());
                return null;
            }
            server.stop(true, (IProgressMonitor)new NullProgressMonitor());
        }
        server.start(mode, (IProgressMonitor)new NullProgressMonitor());
        return null;
    }

    private RailsServer findOrCreateServer(IProject railsProject) {
        RailsServer possible;
        IServer server = this.getServerManager().findServerByName(railsProject.getName());
        if (server instanceof RailsServer && (possible = (RailsServer)server).getProject().equals((Object)railsProject)) {
            return possible;
        }
        List servers = this.getServerManager().getServers();
        for (IServer server2 : servers) {
            RailsServer possible2;
            if (!(server2 instanceof RailsServer) || !(possible2 = (RailsServer)server2).getProject().equals((Object)railsProject)) continue;
            return possible2;
        }
        return this.addServer(railsProject);
    }

    protected RailsServer addServer(IProject project) {
        try {
            IServerManager serverManager = this.getServerManager();
            RailsServer server = (RailsServer)serverManager.createServer("org.radrails.rails.railsServer");
            server.setProject(project);
            server.setName(project.getName());
            serverManager.add((IServer)server);
            return server;
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)RailsUIPlugin.getDefault(), (String)"Error adding server for Rails project", (Throwable)e);
            return null;
        }
    }

    protected IServerManager getServerManager() {
        return WebServerCorePlugin.getDefault().getServerManager();
    }
}

