/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.dialogs;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.IPropertyDialog;
import com.aptana.ui.IPropertyDialogProvider;
import com.aptana.webserver.core.WebServerCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.radrails.rails.internal.RailsServer;
import org.radrails.rails.internal.ui.dialogs.Messages;
import org.radrails.rails.ui.RailsUIPlugin;

public class RailsServerDialog
extends TitleAreaDialog
implements IPropertyDialog {
    private static final int LABEL_WIDTH = 70;
    private RailsServer source;
    private Text nameText;
    private Text hostNameText;
    private Text portText;
    private Combo projectCombo;
    private ModifyListener modifyListener;

    public RailsServerDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    public Object getPropertySource() {
        return this.source;
    }

    public void setPropertySource(Object element) {
        this.source = null;
        if (element instanceof RailsServer) {
            this.source = (RailsServer)((Object)element);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.RailsServerDialog_Title);
        this.getShell().setText(Messages.RailsServerDialog_Message);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        PixelConverter converter = new PixelConverter((Control)composite);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(converter.convertHorizontalDLUsToPixels(7), converter.convertVerticalDLUsToPixels(7)).spacing(converter.convertHorizontalDLUsToPixels(4), converter.convertVerticalDLUsToPixels(4)).numColumns(3).create());
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.RailsServerDialog_NameLabel));
        this.nameText = new Text(composite, 2052);
        this.nameText.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).span(2, 1).grab(true, false).create());
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.RailsServerDialog_ProjectLabel));
        this.projectCombo = new Combo(composite, 2060);
        this.projectCombo.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).span(2, 1).grab(true, false).create());
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isOpen() && project.hasNature("org.radrails.rails.core.railsnature")) {
                    this.projectCombo.add(project.getName());
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)RailsUIPlugin.getDefault(), (Throwable)e);
            }
            ++n2;
        }
        if (this.projectCombo.getItemCount() > 0) {
            this.projectCombo.setText(this.projectCombo.getItems()[0]);
        }
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.RailsServerDialog_BindingLabel));
        this.hostNameText = new Text(composite, 2052);
        this.hostNameText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this.hostNameText).convertHorizontalDLUsToPixels(200), -1).span(2, 1).align(4, 0x1000000).grab(true, false).create());
        this.hostNameText.setText("0.0.0.0");
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.RailsServerDialog_PortLabel));
        this.portText = new Text(composite, 2052);
        this.portText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this.portText).convertHorizontalDLUsToPixels(200), -1).grab(true, false).create());
        this.portText.setText(Integer.toString(3000));
        if (this.source != null) {
            String name = this.source.getName();
            this.nameText.setText(name != null ? name : "");
            String host = this.source.getHostname();
            this.hostNameText.setText(host != null ? host : "0.0.0.0");
            this.portText.setText(Integer.toString(this.source.getPort()));
            IProject project = this.source.getProject();
            if (project != null) {
                this.projectCombo.setText(project.getName());
            }
        }
        this.addListeners();
        return dialogArea;
    }

    protected Control createContents(Composite parent) {
        try {
            Control control = super.createContents(parent);
            return control;
        }
        finally {
            this.validate();
        }
    }

    protected void okPressed() {
        if (!this.isValid()) {
            return;
        }
        if (this.source != null) {
            this.source.setName(this.nameText.getText());
            this.source.setPort(Integer.parseInt(this.portText.getText()));
            this.source.setHost(this.hostNameText.getText());
            this.source.setProject(ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectCombo.getText()));
        }
        WebServerCorePlugin.getDefault().saveServerConfigurations();
        super.okPressed();
    }

    private boolean isValid() {
        if (this.nameText.getText().length() == 0) {
            this.setErrorMessage(Messages.RailsServerDialog_EmptyNameErrorMsg);
            return false;
        }
        try {
            Integer.parseInt(this.portText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.RailsServerDialog_InvalidPortErrorMsg);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    private void validate() {
        boolean valid = this.isValid();
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(valid);
        }
    }

    protected void addListeners() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RailsServerDialog.this.validate();
                }
            };
        }
        this.nameText.addModifyListener(this.modifyListener);
        this.hostNameText.addModifyListener(this.modifyListener);
        this.portText.addModifyListener(this.modifyListener);
        this.projectCombo.addModifyListener(this.modifyListener);
    }

    protected void removeListeners() {
        if (this.modifyListener != null) {
            this.nameText.removeModifyListener(this.modifyListener);
            this.hostNameText.removeModifyListener(this.modifyListener);
            this.portText.removeModifyListener(this.modifyListener);
            this.projectCombo.removeModifyListener(this.modifyListener);
        }
    }

    public static class Provider
    implements IPropertyDialogProvider {
        public Dialog createPropertyDialog(IShellProvider shellProvider) {
            return new RailsServerDialog(shellProvider.getShell());
        }
    }
}

