/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.filter;

import com.aptana.core.util.StringUtil;
import com.aptana.explorer.ui.filter.PathFilter;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.radrails.rails.internal.ui.filter.Inflector;

public class RailsProjectFilter
extends PathFilter {
    protected boolean isElementVisible(Viewer viewer, Object element) {
        IResource resource = (IResource)element;
        String firstSegment = resource.getProjectRelativePath().segment(0);
        if (firstSegment.equals("tmp") || firstSegment.equals("vendor")) {
            return false;
        }
        return super.isElementVisible(viewer, element);
    }

    protected void setPattern(String patternString) {
        this.patternString = patternString;
        this.regexp = StringUtil.isEmpty((String)patternString) ? null : Pattern.compile(MessageFormat.format("\\b({0}|{1})\\b", patternString, Inflector.pluralize(patternString)));
    }

    protected String createPatternFromResource(IResource resource) {
        String text = resource.getName();
        if (text.endsWith("_controller.rb")) {
            text = text.substring(0, text.indexOf("_controller"));
            text = Inflector.singularize(text);
        } else if (text.endsWith("_controller_test.rb")) {
            text = text.substring(0, text.indexOf("_controller_test.rb"));
            text = Inflector.singularize(text);
        } else if (text.endsWith("_helper.rb")) {
            text = text.substring(0, text.indexOf("_helper"));
            text = Inflector.singularize(text);
        } else if (text.endsWith("_helper_test.rb")) {
            text = text.substring(0, text.indexOf("_helper_test.rb"));
            text = Inflector.singularize(text);
        } else if (text.endsWith("_test.rb")) {
            text = text.substring(0, text.indexOf("_test.rb"));
        } else if (text.endsWith("_spec.rb")) {
            text = text.substring(0, text.indexOf("_spec.rb"));
        } else if (text.endsWith(".yml")) {
            IPath path = resource.getProjectRelativePath();
            if (path.segmentCount() >= 3 && path.segment(1).equals("fixtures")) {
                text = text.substring(0, text.indexOf(".yml"));
                text = Inflector.singularize(text);
            }
        } else if (text.endsWith(".rb")) {
            text = text.substring(0, text.indexOf(".rb"));
        } else {
            IPath path = resource.getProjectRelativePath();
            if (path.segmentCount() >= 3 && path.segment(1).equals("views")) {
                text = path.segment(2);
                text = Inflector.singularize(text);
            }
        }
        return text;
    }

    protected String[] indexCategories() {
        return new String[]{"html.resource.css", "html.resource.js", "ruby.require"};
    }
}

