/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.jira.core;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.jira.core.Messages;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JiraIssueType {
    BUG(Messages.JiraIssueType_Bug, "bug"),
    FEATURE(Messages.JiraIssueType_Feature, "APSTUD", "story", "TC", "New Feature"),
    IMPROVEMENT(Messages.JiraIssueType_Improvement, "improvement");

    private String displayName;
    private String parameterValue;
    private Map<String, String> projectKeysToParameterValues;

    public String getDisplayName() {
        return this.displayName;
    }

    public String getParameterValue(String projectKey) {
        String name;
        if (this.projectKeysToParameterValues != null && (name = this.projectKeysToParameterValues.get(projectKey)) != null) {
            return name;
        }
        return this.parameterValue;
    }

    public String toString() {
        return this.displayName;
    }

    private JiraIssueType(String displayName, String parameterValue) {
        this.displayName = displayName;
        this.parameterValue = parameterValue;
    }

    private JiraIssueType(String displayName, String ... projectKeysToParameterValues) {
        this.displayName = displayName;
        this.projectKeysToParameterValues = CollectionsUtil.newMap((Object[])projectKeysToParameterValues);
    }
}

