/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.jira.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.ProcessStatus;
import com.aptana.core.util.ProcessUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.jira.core.JiraCorePlugin;
import com.aptana.jira.core.JiraException;
import com.aptana.jira.core.JiraIssue;
import com.aptana.jira.core.JiraIssueSeverity;
import com.aptana.jira.core.JiraIssueType;
import com.aptana.jira.core.JiraUser;
import com.aptana.jira.core.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class JiraManager {
    private static final String LIBRARY_PLUGIN_ID = "org.swift.jira.cli";
    private static final String JIRA_WIN = "jira.bat";
    private static final String JIRA_UNIX = "jira.sh";
    private static final String PARAM_ACTION = "-a";
    private static final String PARAM_USERNAME = "-u";
    private static final String PARAM_PASSWORD = "-p";
    private static final String PARAM_PROJECT = "--project";
    private static final String PARAM_VERSION = "--affectsVersions";
    private static final String PARAM_TYPE = "--type";
    private static final String PARAM_SUMMARY = "--summary";
    private static final String PARAM_ISSUE = "--issue";
    private static final String PARAM_FILE = "--file";
    private static final String PARAM_ENVIRONMENT = "--environment";
    private static final String ACTION_LOGIN = "login";
    private static final String ACTION_CREATE_ISSUE = "createIssue";
    private static final String ACTION_ADD_ATTACHMENT = "addAttachment";
    private static final String SECURE_PREF_NODE = "com.aptana.jira.core";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final Pattern PATTERN_SUCCESS = Pattern.compile("(.*) created with id (.*). URL: (.*)");
    private static final String FAILED_REASON_START = "Exception: ";
    static final String APTANA_STUDIO = "APSTUD";
    static final String TITANIUM_COMMUNITY = "TC";
    private static IPath jiraExecutable;
    private static String projectName;
    private static String projectKey;
    private JiraUser user;

    static {
        projectName = "Aptana Studio";
        projectKey = APTANA_STUDIO;
    }

    JiraManager() {
        this.loadCredentials();
    }

    public JiraUser getUser() {
        return this.user;
    }

    public void login(String username, String password) throws JiraException {
        IPath jiraExecutable = JiraManager.getJiraExecutable();
        if (jiraExecutable == null) {
            throw new JiraException(Messages.JiraManager_ERR_NoJiraExecutable);
        }
        IStatus status = ProcessUtil.runInBackground((String)jiraExecutable.toOSString(), (IPath)jiraExecutable.removeLastSegments(1), (String[])new String[]{PARAM_ACTION, ACTION_LOGIN, PARAM_USERNAME, username, PARAM_PASSWORD, password});
        if (status != null) {
            StringTokenizer tk;
            String output = "";
            if (status instanceof ProcessStatus) {
                output = ((ProcessStatus)status).getStdErr();
            }
            if (StringUtil.isEmpty((String)output)) {
                output = status.getMessage();
            }
            if ((tk = new StringTokenizer(output = output.trim())).countTokens() == 1) {
                this.user = new JiraUser(username, password);
                this.saveCredentials();
            } else {
                int index = output.lastIndexOf(FAILED_REASON_START);
                if (index > -1) {
                    String reason = output.substring(index + FAILED_REASON_START.length()).trim();
                    throw new JiraException(reason);
                }
                throw new JiraException(output);
            }
        }
    }

    public void logout() {
        ISecurePreferences prefs = JiraManager.getSecurePreferences();
        try {
            prefs.remove(USERNAME);
            prefs.remove(PASSWORD);
            prefs.flush();
            this.user = null;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JiraCorePlugin.getDefault(), (String)"Failed to log out Jira user", (Throwable)e);
        }
    }

    public JiraIssue createIssue(JiraIssueType type, JiraIssueSeverity severity, String summary, String description) throws JiraException, IOException {
        if (this.user == null) {
            throw new JiraException(Messages.JiraManager_ERR_NotLoggedIn);
        }
        IPath jiraExecutable = JiraManager.getJiraExecutable();
        File desc = File.createTempFile("jira-description", ".txt");
        desc.deleteOnExit();
        Charset charset = Charset.forName("UTF-8");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(desc), charset);
        w.write(description);
        w.close();
        String output = ProcessUtil.outputForCommand((String)jiraExecutable.toOSString(), (IPath)jiraExecutable.removeLastSegments(1), (String[])new String[]{PARAM_ACTION, ACTION_CREATE_ISSUE, PARAM_USERNAME, this.user.getUsername(), PARAM_PASSWORD, this.user.getPassword(), PARAM_PROJECT, projectKey, TITANIUM_COMMUNITY.equals(projectKey) ? PARAM_ENVIRONMENT : PARAM_VERSION, JiraManager.getProjectVersion(), PARAM_TYPE, type.getParameterValue(projectKey), PARAM_SUMMARY, summary.replaceAll("\"", "'"), PARAM_FILE, desc.getAbsolutePath(), "--custom", severity.getParameterValue()});
        Matcher m = PATTERN_SUCCESS.matcher(output);
        if (m.find()) {
            String issueName = m.group(1);
            String issueId = m.group(2);
            String issueUrl = m.group(3);
            return new JiraIssue(issueName, issueId, issueUrl);
        }
        throw new JiraException(output);
    }

    public void addAttachment(IPath path, JiraIssue issue) throws JiraException {
        if (path == null || issue == null) {
            return;
        }
        if (this.user == null) {
            throw new JiraException(Messages.JiraManager_ERR_NotLoggedIn);
        }
        IPath jiraExecutable = JiraManager.getJiraExecutable();
        String output = ProcessUtil.outputForCommand((String)jiraExecutable.toOSString(), (IPath)jiraExecutable.removeLastSegments(1), (String[])new String[]{PARAM_ACTION, ACTION_ADD_ATTACHMENT, PARAM_USERNAME, this.user.getUsername(), PARAM_PASSWORD, this.user.getPassword(), PARAM_ISSUE, issue.getId(), PARAM_FILE, path.toOSString()});
        if (!StringUtil.isEmpty((String)output) && output.indexOf("added to") < 0) {
            throw new JiraException(output);
        }
    }

    public static void setProjectInfo(String projectName, String projectKey) {
        if (!StringUtil.isEmpty((String)projectName)) {
            JiraManager.projectName = projectName;
        }
        if (!StringUtil.isEmpty((String)projectKey)) {
            JiraManager.projectKey = projectKey;
        }
    }

    private void loadCredentials() {
        ISecurePreferences prefs = JiraManager.getSecurePreferences();
        try {
            String username = prefs.get(USERNAME, null);
            String password = prefs.get(PASSWORD, null);
            if (!StringUtil.isEmpty((String)username) && !StringUtil.isEmpty((String)password)) {
                this.user = new JiraUser(username, password);
            }
        }
        catch (StorageException e) {
            IdeLog.logError((Plugin)JiraCorePlugin.getDefault(), (String)"Failed to load Jira user credentials", (Throwable)e);
        }
    }

    private void saveCredentials() {
        ISecurePreferences prefs = JiraManager.getSecurePreferences();
        try {
            prefs.put(USERNAME, this.user.getUsername(), true);
            prefs.put(PASSWORD, this.user.getPassword(), true);
            prefs.flush();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JiraCorePlugin.getDefault(), (String)"Failed to save Jira user credentials", (Throwable)e);
        }
    }

    private static IPath getJiraExecutable() {
        if (jiraExecutable == null) {
            try {
                IPath path = "win32".equals(Platform.getOS()) ? Path.fromOSString((String)JIRA_WIN) : Path.fromOSString((String)JIRA_UNIX);
                URL url = FileLocator.find((Bundle)Platform.getBundle((String)LIBRARY_PLUGIN_ID), (IPath)path, null);
                if (url != null) {
                    url = FileLocator.toFileURL((URL)url);
                    jiraExecutable = Path.fromOSString((String)url.getFile());
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JiraCorePlugin.getDefault(), (String)MessageFormat.format("Failed to find plugin {0}", LIBRARY_PLUGIN_ID), (Throwable)e);
            }
        }
        return jiraExecutable;
    }

    private static String getProjectVersion() {
        String versionStr = EclipseUtil.getStudioVersion();
        Version version = new Version(versionStr);
        return MessageFormat.format("{0} {1}.{2}.{3}", projectName, version.getMajor(), version.getMinor(), version.getMicro());
    }

    private static ISecurePreferences getSecurePreferences() {
        return SecurePreferencesFactory.getDefault().node(SECURE_PREF_NODE);
    }
}

