/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.svg;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.editor.svg.Messages;
import com.aptana.editor.svg.SVGPlugin;
import com.aptana.editor.xml.contentassist.index.IKeyProvider;
import com.aptana.editor.xml.contentassist.index.XMLIndexWriter;
import com.aptana.editor.xml.contentassist.index.XMLKeyProvider;
import com.aptana.editor.xml.contentassist.model.AttributeElement;
import com.aptana.editor.xml.contentassist.model.DTDTransformer;
import com.aptana.editor.xml.contentassist.model.ElementElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class SVGMetadataLoader
extends Job {
    private static final String SVG_DTD = "DTD/svg11-flat.dtd";

    public SVGMetadataLoader() {
        super(Messages.MetadataLoader_Loading_SVG_Metadata);
        this.setPriority(30);
    }

    private void rebuildMetadataIndex(IProgressMonitor monitor) {
        try {
            XMLKeyProvider keyProvider = new XMLKeyProvider();
            XMLIndexWriter writer = new XMLIndexWriter((IKeyProvider)keyProvider);
            URI metadataLocation = URI.create(keyProvider.getMetadataLocation());
            this.getIndexManager().removeIndex(metadataLocation);
            InputStream stream = FileLocator.openStream((Bundle)Platform.getBundle((String)"com.aptana.editor.svg"), (IPath)new Path(SVG_DTD), (boolean)false);
            String source = IOUtil.read((InputStream)stream);
            DTDTransformer transformer = new DTDTransformer();
            transformer.transform(source);
            Index index = this.getIndexManager().getIndex(metadataLocation);
            for (ElementElement element : transformer.getElements()) {
                writer.writeElement(index, element);
            }
            for (AttributeElement attribute : transformer.getAttributes()) {
                writer.writeAttribute(index, attribute);
            }
            index.save();
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)SVGPlugin.getDefault(), (Throwable)e);
        }
    }

    protected IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    protected IStatus run(IProgressMonitor monitor) {
        double expectedVersion = Platform.getPreferencesService().getDouble("com.aptana.editor.svg", "SVG_INDEX_VERSION", 0.0, null);
        if (expectedVersion != 0.1) {
            this.rebuildMetadataIndex(monitor);
            this.updateVersionPreference();
        }
        return Status.OK_STATUS;
    }

    private void updateVersionPreference() {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.editor.svg");
        prefs.putDouble("SVG_INDEX_VERSION", 0.1);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }
}

