/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.expressions;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.IExpressionsListener;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractRemoveAllActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class RemoveAllExpressionsAction
extends AbstractRemoveAllActionDelegate
implements IExpressionsListener {
    public void run(IAction action) {
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            boolean prompt = store.getBoolean("org.eclipse.debug.ui.remove_all_expressions_prompt");
            boolean proceed = true;
            if (prompt) {
                MessageDialogWithToggle mdwt = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ActionMessages.RemoveAllExpressionsAction_0, (String)ActionMessages.RemoveAllExpressionsAction_1, (String)ActionMessages.RemoveAllBreakpointsAction_3, (!prompt ? 1 : 0) != 0, null, null);
                if (mdwt.getReturnCode() != 2) {
                    proceed = false;
                } else {
                    store.setValue("org.eclipse.debug.ui.remove_all_expressions_prompt", !mdwt.getToggleState());
                }
            }
            if (proceed) {
                IExpressionManager manager = DebugPlugin.getDefault().getExpressionManager();
                IExpression[] expressions = manager.getExpressions();
                manager.removeExpressions(expressions);
            }
        }
    }

    protected boolean isEnabled() {
        return DebugPlugin.getDefault().getExpressionManager().hasExpressions();
    }

    protected void initialize() {
        DebugPlugin.getDefault().getExpressionManager().addExpressionListener((IExpressionsListener)this);
    }

    public void dispose() {
        DebugPlugin.getDefault().getExpressionManager().removeExpressionListener((IExpressionsListener)this);
        super.dispose();
    }

    public void expressionsAdded(IExpression[] expressions) {
        this.update();
    }

    public void expressionsRemoved(IExpression[] expressions) {
        this.update();
    }

    public void expressionsChanged(IExpression[] expressions) {
    }
}

