/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core;

import com.aptana.core.epl.XMLMemento;
import com.aptana.ide.core.io.ConnectionPointUtils;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.SiteConnection;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class DefaultSiteConnection
extends SiteConnection {
    public static final String NAME = "Default";
    protected static final String STATE_FILENAME = "defaultConnection";
    private static final String ELEMENT_ROOT = "connection";
    private static final String ELEMENT_SITE = "connection";
    private static final String HOME_DIR = System.getProperty("user.home");
    private static DefaultSiteConnection fInstance;

    private DefaultSiteConnection() {
    }

    public static DefaultSiteConnection getInstance() {
        if (fInstance == null) {
            fInstance = new DefaultSiteConnection();
            fInstance.setName(NAME);
            fInstance.setSource(DefaultSiteConnection.getDefaultSource());
        }
        return fInstance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadState(IPath path) {
        File file = path.toFile();
        if (!file.exists()) return;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
            this.loadState(memento.getChild("connection"));
            fInstance.setName(NAME);
            if (fInstance.getSource() == null) {
                fInstance.setSource(DefaultSiteConnection.getDefaultSource());
            }
            fInstance.setDestination(null);
        }
        catch (IOException iOException) {
            if (reader == null) return;
            try {
                reader.close();
                return;
            }
            catch (IOException iOException2) {}
            return;
        }
        catch (CoreException coreException) {
            try {
                if (reader == null) return;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException iOException) {}
    }

    protected void saveState(IPath path) {
        block14: {
            XMLMemento memento = XMLMemento.createWriteRoot((String)"connection");
            this.saveState(memento.createChild("connection"));
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(path.toFile());
                    memento.save((Writer)writer);
                    this.isChanged();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static IConnectionPoint getDefaultSource() {
        return ConnectionPointUtils.findOrCreateLocalConnectionPoint((IPath)Path.fromOSString((String)HOME_DIR));
    }
}

