/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;

public class ResourceSynchronizationUtils {
    public static final String LAST_SYNC_CONNECTION_KEY = "lastSyncConnection";
    public static final String REMEMBER_DECISION_KEY = "rememberDecision";
    private static final QualifiedName REMEMBER_DECISION = new QualifiedName("", "rememberDecision");
    private static final QualifiedName LAST_SYNC_CONNECTION = new QualifiedName("", "lastSyncConnection");

    public static boolean isRememberDecision(IContainer container) {
        if (container == null) {
            throw new NullPointerException("Null resource container.");
        }
        try {
            return Boolean.parseBoolean(container.getPersistentProperty(REMEMBER_DECISION));
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (String)"Failed to retrieve the setting for \"remember my decision\"", (Throwable)e);
            return false;
        }
    }

    public static void setRememberDecision(IContainer container, boolean rememberMyDecision) {
        if (container == null) {
            throw new NullPointerException("Null resource container.");
        }
        try {
            container.setPersistentProperty(REMEMBER_DECISION, String.valueOf(rememberMyDecision));
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (String)"Failed to set the setting of \"remember my decision\"", (Throwable)e);
        }
    }

    public static String getLastSyncConnection(IContainer container) {
        if (container == null) {
            throw new NullPointerException("Null resource container.");
        }
        try {
            return container.getPersistentProperty(LAST_SYNC_CONNECTION);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (String)"Failed to retrieve the setting for the last synchronization connection", (Throwable)e);
            return null;
        }
    }

    public static void setLastSyncConnection(IContainer container, String connection) {
        if (container == null) {
            throw new NullPointerException("Null resource container.");
        }
        try {
            if (StringUtil.isEmpty((String)connection)) {
                container.setPersistentProperty(LAST_SYNC_CONNECTION, null);
            } else {
                container.setPersistentProperty(LAST_SYNC_CONNECTION, connection);
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (String)"Failed to set the setting of the last synchronization connection", (Throwable)e);
        }
    }
}

