/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core;

import com.aptana.core.epl.IMemento;
import com.aptana.ide.core.io.ConnectionPointType;
import com.aptana.ide.core.io.ConnectionPointUtils;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.Messages;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;

class SiteConnection
extends PlatformObject
implements ISiteConnection {
    private static final String ELEMENT_NAME = "name";
    private static final String ELEMENT_SOURCE = "source";
    private static final String ELEMENT_DESTINATION = "destination";
    private static final String ELEMENT_EXCLUDES = "excludes";
    private static final String ELEMENT_PATH = "path";
    private static final String ELEMENT_WILDCARD = "wildcard";
    private String name;
    private IConnectionPoint sourceConnectionPoint;
    private IConnectionPoint destinationConnectionPoint;
    private List<Object> excludes = new ArrayList<Object>();
    private boolean dirty;

    SiteConnection() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.notifyChanged();
    }

    public IConnectionPoint getSource() {
        return this.sourceConnectionPoint;
    }

    public void setSource(IConnectionPoint source) {
        this.sourceConnectionPoint = source;
        this.notifyChanged();
    }

    public IConnectionPoint getDestination() {
        return this.destinationConnectionPoint;
    }

    public void setDestination(IConnectionPoint destination) {
        this.destinationConnectionPoint = destination;
        this.notifyChanged();
    }

    public boolean excludes(IPath path) {
        for (Object i : this.excludes) {
            if (!(i instanceof IPath) || !path.equals(i)) continue;
            return true;
        }
        return false;
    }

    public void addExcludePath(IPath path) {
        if (!this.excludes.contains(path)) {
            this.excludes.add(path);
        }
    }

    public void addExcludeWildcard(String wildcard) {
        if (!this.excludes.contains(wildcard)) {
            this.excludes.add(wildcard);
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append('(');
        IConnectionPoint source = this.getSource();
        if (source == null) {
            text.append(Messages.SiteConnection_LBL_NoSource);
        } else {
            ConnectionPointType type = CoreIOPlugin.getConnectionPointManager().getType(source);
            if (type != null) {
                text.append(type.getName()).append(':');
            }
            text.append(source.getName());
        }
        text.append(" <-> ");
        IConnectionPoint target = this.getDestination();
        if (target == null) {
            text.append(Messages.SiteConnection_LBL_NoDestination);
        } else {
            ConnectionPointType type = CoreIOPlugin.getConnectionPointManager().getType(target);
            if (type != null) {
                text.append(type.getName()).append(':');
            }
            text.append(target.getName());
        }
        text.append(')');
        return text.toString();
    }

    protected void loadState(IMemento memento) {
        URI uri;
        IMemento child = memento.getChild(ELEMENT_NAME);
        if (child != null) {
            this.name = child.getTextData();
        }
        if ((child = memento.getChild(ELEMENT_SOURCE)) != null) {
            uri = URI.create(child.getTextData());
            this.sourceConnectionPoint = ConnectionPointUtils.findConnectionPoint((URI)uri);
        }
        if ((child = memento.getChild(ELEMENT_DESTINATION)) != null) {
            uri = URI.create(child.getTextData());
            this.destinationConnectionPoint = ConnectionPointUtils.findConnectionPoint((URI)uri);
        }
        if ((child = memento.getChild(ELEMENT_EXCLUDES)) != null) {
            IMemento i;
            IMemento[] iMementoArray = child.getChildren(ELEMENT_PATH);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                i = iMementoArray[n2];
                this.excludes.add(Path.fromPortableString((String)i.getTextData()));
                ++n2;
            }
            iMementoArray = child.getChildren(ELEMENT_WILDCARD);
            n = iMementoArray.length;
            n2 = 0;
            while (n2 < n) {
                i = iMementoArray[n2];
                this.excludes.add(i.getTextData());
                ++n2;
            }
        }
    }

    protected void saveState(IMemento memento) {
        memento.createChild(ELEMENT_NAME).putTextData(this.name);
        if (this.sourceConnectionPoint != null) {
            memento.createChild(ELEMENT_SOURCE).putTextData(this.sourceConnectionPoint.getRootURI().toString());
        }
        if (this.destinationConnectionPoint != null) {
            memento.createChild(ELEMENT_DESTINATION).putTextData(this.destinationConnectionPoint.getRootURI().toString());
        }
        if (!this.excludes.isEmpty()) {
            IMemento excludesMemento = memento.createChild(ELEMENT_EXCLUDES);
            for (Object i : this.excludes) {
                if (i instanceof IPath) {
                    excludesMemento.createChild(ELEMENT_PATH).putTextData(((IPath)i).toPortableString());
                    continue;
                }
                if (!(i instanceof String)) continue;
                excludesMemento.createChild(ELEMENT_PATH).putTextData((String)i);
            }
        }
    }

    protected final void notifyChanged() {
        this.dirty = true;
    }

    final boolean isChanged() {
        try {
            boolean bl = this.dirty;
            return bl;
        }
        finally {
            this.dirty = false;
        }
    }

    final boolean isValid() {
        return this.sourceConnectionPoint != null && this.destinationConnectionPoint != null;
    }
}

