/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core;

import com.aptana.core.epl.IMemento;
import com.aptana.core.epl.XMLMemento;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.IConnectionPoint15Constants;
import com.aptana.ide.core.io.IConnectionPointManager;
import com.aptana.ide.syncing.core.DefaultSiteConnection;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.ISiteConnectionManager;
import com.aptana.ide.syncing.core.Messages;
import com.aptana.ide.syncing.core.SiteConnection;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.core.events.ISiteConnectionListener;
import com.aptana.ide.syncing.core.events.SiteConnectionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SiteConnectionManager
implements ISiteConnectionManager {
    protected static final String STATE_FILENAME = "sites";
    private static final String ELEMENT_ROOT = "sites";
    private static final String ELEMENT_SITE = "site";
    private static SiteConnectionManager instance;
    private List<SiteConnection> connections = Collections.synchronizedList(new ArrayList());
    private boolean dirty = false;
    private ListenerList listeners = new ListenerList();

    private SiteConnectionManager() {
    }

    public static SiteConnectionManager getInstance() {
        if (instance == null) {
            instance = new SiteConnectionManager();
        }
        return instance;
    }

    void loadState(IPath path) {
        File file = path.toFile();
        if (file.exists()) {
            this.connections.clear();
            this.addConnectionsFrom(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveState(IPath path) {
        block18: {
            XMLMemento memento = XMLMemento.createWriteRoot((String)"sites");
            List<SiteConnection> list = this.connections;
            synchronized (list) {
                for (SiteConnection siteConnection : this.connections) {
                    IMemento child = memento.createChild(ELEMENT_SITE);
                    child.putMemento(this.storeConnection(siteConnection));
                }
            }
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(path.toFile());
                    memento.save((Writer)writer);
                    this.isChanged();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public List<ISiteConnection> addConnectionsFrom(IPath path) {
        List<ISiteConnection> newConnections = this.readConnectionsFrom(path);
        for (ISiteConnection connection : newConnections) {
            this.connections.add((SiteConnection)connection);
        }
        return newConnections;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<ISiteConnection> readConnectionsFrom(IPath path) {
        ArrayList<ISiteConnection> newConnections = new ArrayList<ISiteConnection>();
        File file = path.toFile();
        if (!file.exists()) return newConnections;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
            IMemento[] iMementoArray = memento.getChildren(ELEMENT_SITE);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                SiteConnection siteConnection = this.restoreConnection(child);
                if (siteConnection != null && siteConnection.isValid()) {
                    newConnections.add(siteConnection);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (String)Messages.SiteConnectionManager_ERR_FailedToLoadConnections, (Throwable)e);
            if (reader == null) return newConnections;
            try {
                reader.close();
                return newConnections;
            }
            catch (IOException iOException) {}
            return newConnections;
        }
        catch (CoreException coreException) {
            try {
                try {
                    this.load15State(file);
                }
                catch (Exception e1) {
                    IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (String)Messages.SiteConnectionManager_ERR_FailedToLoadConnections, (Throwable)e1);
                }
                if (reader == null) return newConnections;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
                return newConnections;
            }
            catch (IOException iOException) {}
            return newConnections;
        }
        if (reader == null) return newConnections;
        try {
            reader.close();
            return newConnections;
        }
        catch (IOException iOException) {}
        return newConnections;
    }

    private IMemento storeConnection(SiteConnection siteConnection) {
        IMemento saveMemento = XMLMemento.createWriteRoot((String)"sites").createChild(ELEMENT_SITE);
        siteConnection.saveState(saveMemento);
        return saveMemento;
    }

    private SiteConnection restoreConnection(IMemento memento) {
        SiteConnection siteConnection = new SiteConnection();
        siteConnection.loadState(memento);
        return siteConnection;
    }

    public boolean isChanged() {
        for (SiteConnection siteConnection : this.connections) {
            if (!siteConnection.isChanged()) continue;
            this.dirty = true;
        }
        try {
            boolean bl = this.dirty;
            return bl;
        }
        finally {
            this.dirty = false;
        }
    }

    @Override
    public void addSiteConnection(ISiteConnection siteConnection) {
        if (!(siteConnection instanceof SiteConnection)) {
            throw new IllegalArgumentException();
        }
        if (!this.connections.contains(siteConnection)) {
            this.connections.add((SiteConnection)siteConnection);
            this.dirty = true;
            this.broadcastEvent(new SiteConnectionEvent(this, 1, siteConnection));
        }
    }

    @Override
    public void removeSiteConnection(ISiteConnection siteConnection) {
        if (this.connections.contains(siteConnection)) {
            this.connections.remove(siteConnection);
            this.dirty = true;
            this.broadcastEvent(new SiteConnectionEvent(this, 2, siteConnection));
        }
    }

    @Override
    public void siteConnectionChanged(ISiteConnection siteConnection) {
        if (this.connections.contains(siteConnection)) {
            this.dirty = true;
            this.broadcastEvent(new SiteConnectionEvent(this, 4, siteConnection));
        }
    }

    @Override
    public ISiteConnection cloneSiteConnection(ISiteConnection siteConnection) throws CoreException {
        if (!(siteConnection instanceof SiteConnection)) {
            throw new IllegalArgumentException();
        }
        if (siteConnection == DefaultSiteConnection.getInstance()) {
            SiteConnection clone = new SiteConnection();
            clone.setName(siteConnection.getName());
            clone.setSource(siteConnection.getSource());
            clone.setDestination(siteConnection.getDestination());
            return clone;
        }
        return this.restoreConnection(this.storeConnection((SiteConnection)siteConnection));
    }

    @Override
    public ISiteConnection createSiteConnection() {
        return new SiteConnection();
    }

    @Override
    public ISiteConnection[] getSiteConnections() {
        return this.connections.toArray(new ISiteConnection[this.connections.size()]);
    }

    @Override
    public void addListener(ISiteConnectionListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(ISiteConnectionListener listener) {
        this.listeners.add((Object)listener);
    }

    private void broadcastEvent(SiteConnectionEvent event) {
        Object[] list;
        Object[] objectArray = list = this.listeners.getListeners();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISiteConnectionListener)listener).siteConnectionChanged(event);
            ++n2;
        }
    }

    private void load15State(File file) throws IOException, CoreException {
        String[] sections;
        String s;
        StringBuilder contents = new StringBuilder();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        if ((s = contents.toString()).indexOf(IConnectionPoint15Constants.DELIMITER) < 0) {
            s = StringUtil.replace((String)s, (String)"%%%%", (String)IConnectionPoint15Constants.DELIMITER);
            s = StringUtil.replace((String)s, (String)"@@@@", (String)IConnectionPoint15Constants.OBJ_DELIMITER);
            s = StringUtil.replace((String)s, (String)"~~~~", (String)IConnectionPoint15Constants.SECTION_DELIMITER);
            s = StringUtil.replace((String)s, (String)"!!!!", (String)IConnectionPoint15Constants.TYPE_DELIMITER);
            s = StringUtil.replace((String)s, (String)"}}}}", (String)IConnectionPoint15Constants.FILE_DELIMITER);
        }
        if ((sections = s.split(IConnectionPoint15Constants.SECTION_DELIMITER)).length > 0) {
            this.load15VirtualFileManagers(sections[0]);
        }
        if (sections.length > 1) {
            this.load15VirtualFileManagerSyncItems(sections[1]);
        }
    }

    private void load15VirtualFileManagers(String s) throws CoreException {
        String[] parts;
        HashMap<String, ArrayList<String>> dataTypes = new HashMap<String, ArrayList<String>>();
        String[] stringArray = parts = s.split(IConnectionPoint15Constants.OBJ_DELIMITER);
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            String[] itemParts = item.split(IConnectionPoint15Constants.TYPE_DELIMITER);
            if (itemParts.length == 2) {
                String type = itemParts[0];
                String data = itemParts[1];
                if (!"null".equals(type)) {
                    ArrayList<String> list = (ArrayList<String>)dataTypes.get(type);
                    if (list == null) {
                        list = new ArrayList<String>();
                        dataTypes.put(type, list);
                    }
                    list.add(data);
                }
            }
            ++n2;
        }
        Set types = dataTypes.keySet();
        IConnectionPointManager manager = CoreIOPlugin.getConnectionPointManager();
        for (String type : types) {
            List connectionDatas = (List)dataTypes.get(type);
            for (String connectionData : connectionDatas) {
                IConnectionPoint connectionPoint = manager.restore15ConnectionPoint(type, connectionData);
                if (connectionPoint == null) continue;
                manager.addConnectionPoint(connectionPoint);
            }
        }
    }

    private void load15VirtualFileManagerSyncItems(String s) {
        String[] parts;
        String[] stringArray = parts = s.split(IConnectionPoint15Constants.OBJ_DELIMITER);
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            String[] itemParts = item.split(IConnectionPoint15Constants.TYPE_DELIMITER);
            if (itemParts.length == 2) {
                ISiteConnection connection;
                String type = itemParts[0];
                String data = itemParts[1];
                if (!"null".equals(type) && (connection = this.restore15Connection(data)) != null && connection.getSource() != null && connection.getDestination() != null) {
                    this.addSiteConnection(connection);
                }
            }
            ++n2;
        }
    }

    private ISiteConnection restore15Connection(String data) {
        IConnectionPoint[] connectionPoints;
        String[] args = data.split(IConnectionPoint15Constants.DELIMITER);
        if (args.length < 3) {
            return null;
        }
        ISiteConnection siteConnection = this.createSiteConnection();
        siteConnection.setName(args[0]);
        String sourceId = args[1];
        String destinationId = args[2];
        IConnectionPoint[] iConnectionPointArray = connectionPoints = CoreIOPlugin.getConnectionPointManager().getConnectionPoints();
        int n = connectionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionPoint connectionPoint = iConnectionPointArray[n2];
            String id = connectionPoint.getId();
            if (id.equals(sourceId)) {
                siteConnection.setSource(connectionPoint);
            } else if (id.equals(destinationId)) {
                siteConnection.setDestination(connectionPoint);
            }
            ++n2;
        }
        return siteConnection;
    }
}

