/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core;

import com.aptana.ide.core.io.ConnectionPointUtils;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.SiteConnectionManager;
import com.aptana.ide.syncing.core.SyncingPlugin;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;

public final class SiteConnectionUtils {
    private SiteConnectionUtils() {
    }

    public static ISiteConnection createSite(String name, IConnectionPoint source, IConnectionPoint destination) {
        ISiteConnection site = SiteConnectionManager.getInstance().createSiteConnection();
        site.setName(name);
        site.setSource(source);
        site.setDestination(destination);
        return site;
    }

    public static ISiteConnection[] findSitesForSource(IAdaptable object) {
        return SiteConnectionUtils.findSitesForSource(object, false);
    }

    public static ISiteConnection[] findSitesForSource(IAdaptable object, boolean strict) {
        return SiteConnectionUtils.findSitesForSource(object, strict, false);
    }

    public static ISiteConnection[] findSitesForSource(IAdaptable object, boolean strict, boolean includeChildren) {
        ArrayList<ISiteConnection> list;
        block10: {
            ISiteConnection[] allsites;
            block11: {
                block9: {
                    list = new ArrayList<ISiteConnection>();
                    allsites = SyncingPlugin.getSiteConnectionManager().getSiteConnections();
                    IConnectionPoint connectionPoint = (IConnectionPoint)object.getAdapter(IConnectionPoint.class);
                    if (connectionPoint == null) break block9;
                    ISiteConnection[] iSiteConnectionArray = allsites;
                    int n = allsites.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISiteConnection i = iSiteConnectionArray[n2];
                        if (connectionPoint.equals(i.getSource())) {
                            list.add(i);
                        }
                        ++n2;
                    }
                    break block10;
                }
                IResource resource = (IResource)object.getAdapter(IResource.class);
                if (resource == null) break block11;
                ISiteConnection[] iSiteConnectionArray = allsites;
                int n = allsites.length;
                int n3 = 0;
                while (n3 < n) {
                    IConnectionPoint destination;
                    IContainer connectionRoot;
                    ISiteConnection i = iSiteConnectionArray[n3];
                    IConnectionPoint sourceConnectionPoint = i.getSource();
                    if (sourceConnectionPoint != null && (connectionRoot = (IContainer)sourceConnectionPoint.getAdapter(IResource.class)) != null && (connectionRoot.equals((Object)resource) || !strict && SiteConnectionUtils.contains((IResource)connectionRoot, resource) || includeChildren && SiteConnectionUtils.contains(resource, (IResource)connectionRoot)) && (destination = i.getDestination()) != null && ConnectionPointUtils.findConnectionPoint((URI)destination.getRootURI()) != null) {
                        list.add(i);
                    }
                    ++n3;
                }
                break block10;
            }
            IFileStore fileStore = (IFileStore)object.getAdapter(IFileStore.class);
            if (fileStore == null) break block10;
            ISiteConnection[] iSiteConnectionArray = allsites;
            int n = allsites.length;
            int n4 = 0;
            while (n4 < n) {
                ISiteConnection i = iSiteConnectionArray[n4];
                IConnectionPoint sourceConnectionPoint = i.getSource();
                if (sourceConnectionPoint != null) {
                    try {
                        IConnectionPoint destination;
                        IFileStore root = sourceConnectionPoint.getRoot();
                        if (root != null && (root.equals(fileStore) || !strict && root.isParentOf(fileStore) || includeChildren && fileStore.isParentOf(root)) && (destination = i.getDestination()) != null && ConnectionPointUtils.findConnectionPoint((URI)destination.getRootURI()) != null) {
                            list.add(i);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++n4;
            }
        }
        return list.toArray(new ISiteConnection[list.size()]);
    }

    public static ISiteConnection[] findSitesWithDestination(IAdaptable object) {
        return SiteConnectionUtils.findSitesWithDestination(object, false);
    }

    public static ISiteConnection[] findSitesWithDestination(IAdaptable object, boolean strict) {
        ArrayList<ISiteConnection> list;
        block10: {
            ISiteConnection[] allsites;
            block11: {
                block9: {
                    list = new ArrayList<ISiteConnection>();
                    allsites = SyncingPlugin.getSiteConnectionManager().getSiteConnections();
                    IConnectionPoint connectionPoint = (IConnectionPoint)object.getAdapter(IConnectionPoint.class);
                    if (connectionPoint == null) break block9;
                    ISiteConnection[] iSiteConnectionArray = allsites;
                    int n = allsites.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISiteConnection i = iSiteConnectionArray[n2];
                        if (connectionPoint.equals(i.getDestination())) {
                            list.add(i);
                        }
                        ++n2;
                    }
                    break block10;
                }
                IResource resource = (IResource)object.getAdapter(IResource.class);
                if (resource == null) break block11;
                ISiteConnection[] iSiteConnectionArray = allsites;
                int n = allsites.length;
                int n3 = 0;
                while (n3 < n) {
                    IContainer connectionRoot;
                    ISiteConnection i = iSiteConnectionArray[n3];
                    IConnectionPoint destinationConnectionPoint = i.getDestination();
                    if (destinationConnectionPoint != null && (connectionRoot = (IContainer)destinationConnectionPoint.getAdapter(IResource.class)) != null && (connectionRoot.equals((Object)resource) || !strict && SiteConnectionUtils.contains((IResource)connectionRoot, resource))) {
                        list.add(i);
                    }
                    ++n3;
                }
                break block10;
            }
            IFileStore fileStore = (IFileStore)object.getAdapter(IFileStore.class);
            if (fileStore == null) break block10;
            ISiteConnection[] iSiteConnectionArray = allsites;
            int n = allsites.length;
            int n4 = 0;
            while (n4 < n) {
                ISiteConnection i = iSiteConnectionArray[n4];
                IConnectionPoint destinationConnectionPoint = i.getDestination();
                if (destinationConnectionPoint != null) {
                    try {
                        IFileStore root = destinationConnectionPoint.getRoot();
                        if (root != null && (root.equals(fileStore) || !strict && root.isParentOf(fileStore))) {
                            list.add(i);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++n4;
            }
        }
        return list.toArray(new ISiteConnection[list.size()]);
    }

    public static ISiteConnection[] findSites(IAdaptable source, IConnectionPoint destination) {
        ISiteConnection[] sites;
        ArrayList<ISiteConnection> list = new ArrayList<ISiteConnection>();
        ISiteConnection[] iSiteConnectionArray = sites = SiteConnectionUtils.findSitesForSource(source, true);
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteConnection site = iSiteConnectionArray[n2];
            if (site.getDestination() == destination) {
                list.add(site);
            }
            ++n2;
        }
        return list.toArray(new ISiteConnection[list.size()]);
    }

    public static ISiteConnection getSiteWithDestination(String destinationName, ISiteConnection[] sites) {
        ISiteConnection[] iSiteConnectionArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteConnection site = iSiteConnectionArray[n2];
            IConnectionPoint destination = site.getDestination();
            if (destination != null && destination.getName().equals(destinationName)) {
                return site;
            }
            ++n2;
        }
        return null;
    }

    private static boolean contains(IResource container, IResource resource) {
        return container.getFullPath().isPrefixOf(resource.getFullPath());
    }

    public static boolean isSiteNameUnique(String siteName) {
        ISiteConnection[] siteConnections;
        ISiteConnection[] iSiteConnectionArray = siteConnections = SyncingPlugin.getSiteConnectionManager().getSiteConnections();
        int n = siteConnections.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteConnection connection = iSiteConnectionArray[n2];
            if (connection.getName().equalsIgnoreCase(siteName)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

