/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core.old;

import com.aptana.core.io.efs.EFSUtils;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.old.ISyncEventHandler;
import com.aptana.ide.syncing.core.old.Synchronizer;
import com.aptana.ide.syncing.core.old.VirtualFileSyncPair;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncJob
extends Job
implements ISyncEventHandler {
    public static final int BOTH = 0;
    public static final int UPLOAD = 1;
    public static final int DOWNLOAD = 2;
    private Synchronizer fSyncer;
    private List<VirtualFileSyncPair> fPairs;
    private int fDirection;
    private boolean fDeleteRemote;
    private boolean fDeleteLocal;
    private List<VirtualFileSyncPair> fCompletedPairs;
    private int fErrorPairs;
    private Client fClient;

    public SyncJob(Synchronizer syncer, List<VirtualFileSyncPair> pairs, int direction, boolean deleteRemote, boolean deleteLocal, Client client, String name) {
        super(MessageFormat.format("Synchronizing {0}", name));
        this.fSyncer = syncer;
        this.fPairs = pairs;
        this.fDirection = direction;
        this.fDeleteRemote = deleteRemote;
        this.fDeleteLocal = deleteLocal;
        this.fClient = client;
        this.fCompletedPairs = new ArrayList<VirtualFileSyncPair>();
        this.sortPairs();
        this.fSyncer.setEventHandler(this);
    }

    public VirtualFileSyncPair[] getCompletedPairs() {
        return this.fCompletedPairs.toArray(new VirtualFileSyncPair[this.fCompletedPairs.size()]);
    }

    public long getTotalTransferBytes() {
        long bytes = 0L;
        int size = this.fPairs.size();
        int i = 0;
        while (i < size) {
            bytes += this.getTransferBytes(this.fPairs.get(i));
            ++i;
        }
        return bytes;
    }

    public long getTransferBytes(VirtualFileSyncPair pair) {
        switch (this.fDirection) {
            case 0: {
                int state = pair.getSyncState();
                if (state == 4 || state == 6 || state == 9) {
                    return pair.getSourceFile().fetchInfo().getLength();
                }
                if (state == 5 || state == 7 || state == 10) {
                    return pair.getDestinationFile().fetchInfo().getLength();
                }
                return 0L;
            }
            case 1: {
                return pair.getSourceFile().fetchInfo().getLength();
            }
            case 2: {
                return pair.getDestinationFile().fetchInfo().getLength();
            }
        }
        return 0L;
    }

    public int getErrorCount() {
        return this.fPairs.size() - this.fCompletedPairs.size();
    }

    @Override
    public boolean syncContinue(IProgressMonitor monitor) {
        return !monitor.isCanceled();
    }

    @Override
    public void syncDone(VirtualFileSyncPair item, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        this.fCompletedPairs.add(item);
        int syncState = item.getSyncState();
        if (syncState == 6 && this.fDeleteLocal && (this.fDirection == 0 || this.fDirection == 2)) {
            item.setSyncState(9);
        } else if (syncState == 7 && this.fDeleteRemote && (this.fDirection == 0 || this.fDirection == 1)) {
            item.setSyncState(10);
        }
        if (this.fClient != null) {
            this.fClient.syncDone(item, this.isDone());
        }
    }

    @Override
    public boolean syncErrorEvent(VirtualFileSyncPair item, Exception e, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        ++this.fErrorPairs;
        if (this.fClient != null) {
            this.fClient.syncError(item, this.isDone());
        }
        return true;
    }

    @Override
    public boolean syncEvent(VirtualFileSyncPair item, int index, int totalItems, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        if (this.fClient != null) {
            this.fClient.syncItem(item);
        }
        return true;
    }

    @Override
    public void syncTransferring(VirtualFileSyncPair item, long bytes, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        if (this.fClient != null) {
            this.fClient.syncProgress(item, bytes);
        }
    }

    @Override
    public boolean getFilesEvent(IConnectionPoint manager, String path) {
        return true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.fPairs.size() == 0) {
            if (this.fClient != null) {
                this.fClient.syncDone(null, true);
            }
        } else {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Syncing files", (int)this.fPairs.size());
            VirtualFileSyncPair[] pairs = this.fPairs.toArray(new VirtualFileSyncPair[this.fPairs.size()]);
            switch (this.fDirection) {
                case 0: {
                    this.fullSync(pairs, (IProgressMonitor)sub.newChild(this.fPairs.size()));
                    break;
                }
                case 1: {
                    this.upload(pairs, (IProgressMonitor)sub.newChild(this.fPairs.size()));
                    break;
                }
                case 2: {
                    this.download(pairs, (IProgressMonitor)sub.newChild(this.fPairs.size()));
                }
            }
        }
        return Status.OK_STATUS;
    }

    private boolean fullSync(VirtualFileSyncPair[] pairs, IProgressMonitor sub) {
        return this.fSyncer.fullSyncAndDelete(pairs, this.fDeleteLocal, this.fDeleteRemote, sub);
    }

    private boolean download(VirtualFileSyncPair[] pairs, IProgressMonitor sub) {
        try {
            this.fSyncer.downloadAndDelete(pairs, this.fDeleteLocal, sub);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean upload(VirtualFileSyncPair[] pairs, IProgressMonitor sub) {
        try {
            this.fSyncer.uploadAndDelete(pairs, this.fDeleteRemote, sub);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isDone() {
        return this.fCompletedPairs.size() + this.fErrorPairs == this.fPairs.size();
    }

    private void sortPairs() {
        Collections.sort(this.fPairs, new Comparator<VirtualFileSyncPair>(){

            @Override
            public int compare(VirtualFileSyncPair pair1, VirtualFileSyncPair pair2) {
                try {
                    if (pair1 != null && pair2 != null) {
                        if (SyncJob.this.fDeleteLocal && pair1.getSyncState() == 6 && pair2.getSyncState() == 6 && pair1.getSourceFile() != null && pair2.getSourceFile() != null) {
                            String s1 = EFSUtils.getAbsolutePath((IFileStore)pair1.getSourceFile());
                            String s2 = EFSUtils.getAbsolutePath((IFileStore)pair2.getSourceFile());
                            if (s1 != null) {
                                return -1 * s1.compareToIgnoreCase(s2);
                            }
                        } else if (SyncJob.this.fDeleteRemote && pair1.getSyncState() == 7 && pair2.getSyncState() == 7 && pair1.getDestinationFile() != null && pair2.getDestinationFile() != null) {
                            String s1 = EFSUtils.getAbsolutePath((IFileStore)pair1.getDestinationFile());
                            String s2 = EFSUtils.getAbsolutePath((IFileStore)pair2.getDestinationFile());
                            if (s1 != null) {
                                return -1 * s1.compareToIgnoreCase(s2);
                            }
                        }
                    }
                }
                catch (Exception exception) {}
                return 0;
            }
        });
    }

    public static interface Client {
        public void syncItem(VirtualFileSyncPair var1);

        public void syncProgress(VirtualFileSyncPair var1, long var2);

        public void syncDone(VirtualFileSyncPair var1, boolean var2);

        public void syncError(VirtualFileSyncPair var1, boolean var2);
    }
}

