/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core.old;

import com.aptana.core.logging.IdeLog;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.core.old.Messages;
import java.io.InputStream;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;

public class VirtualFileSyncPair {
    public static final int Direction_None = 0;
    public static final int Direction_ClientToServer = 1;
    public static final int Direction_ServerToClient = 2;
    private String _relativePath;
    private IFileStore _sourceFile;
    private IFileInfo _sourceFileInfo = null;
    private IFileStore _destinationFile;
    private IFileInfo _destinationFileInfo = null;
    private int _syncState;
    private int _syncDirection = 0;

    public VirtualFileSyncPair(IFileStore sourceFile, IFileStore destinationFile, String relativePath, int syncState) {
        this._sourceFile = sourceFile;
        this._destinationFile = destinationFile;
        this._relativePath = relativePath;
        this._syncState = syncState;
    }

    public IFileStore getSourceFile() {
        return this._sourceFile;
    }

    public IFileInfo getSourceFileInfo() {
        try {
            return this.getSourceFileInfo(null);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (String)Messages.VirtualFileSyncPair_SourceFileInfoError, (Throwable)e);
            return null;
        }
    }

    public IFileInfo getSourceFileInfo(IProgressMonitor monitor) throws CoreException {
        if (this._sourceFile == null) {
            return null;
        }
        if (this._sourceFileInfo == null) {
            this._sourceFileInfo = this._sourceFile.fetchInfo(1024, monitor);
        }
        return this._sourceFileInfo;
    }

    public InputStream getSourceInputStream() throws CoreException {
        InputStream result = null;
        if (this._sourceFile != null && !this._sourceFile.fetchInfo().isDirectory()) {
            result = this._sourceFile.openInputStream(0, null);
        }
        return result;
    }

    public void setSourceFile(IFileStore sourceFile) {
        this._sourceFile = sourceFile;
        this._sourceFileInfo = null;
    }

    public IFileStore getDestinationFile() {
        return this._destinationFile;
    }

    public IFileInfo getDestinationFileInfo() {
        try {
            return this.getDestinationFileInfo(null);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (String)Messages.VirtualFileSyncPair_DestFileInfoErrror, (Throwable)e);
            return null;
        }
    }

    public IFileInfo getDestinationFileInfo(IProgressMonitor monitor) throws CoreException {
        if (this._destinationFile == null) {
            return null;
        }
        if (this._destinationFileInfo == null) {
            this._destinationFileInfo = this._destinationFile.fetchInfo(1024, monitor);
        }
        return this._destinationFileInfo;
    }

    public InputStream getDestinationInputStream() throws CoreException {
        InputStream result = null;
        if (this._destinationFile != null && !this._destinationFile.fetchInfo().isDirectory()) {
            result = this._destinationFile.openInputStream(0, null);
        }
        return result;
    }

    public void setDestinationFile(IFileStore destinationFile) {
        this._destinationFile = destinationFile;
        this._destinationFileInfo = null;
    }

    public String getRelativePath() {
        return this._relativePath;
    }

    public int getSyncState() {
        return this._syncState;
    }

    public void setSyncState(int syncState) {
        this._syncState = syncState;
    }

    public int getSyncDirection() {
        return this._syncDirection;
    }

    public void setSyncDirection(int direction) {
        this._syncDirection = direction;
    }

    public boolean isDirectory() {
        if (this.getSyncState() == 8) {
            return false;
        }
        if (this.getSourceFile() != null && this.getSourceFile().fetchInfo().isDirectory()) {
            return true;
        }
        return this.getDestinationFile() != null && this.getDestinationFile().fetchInfo().isDirectory();
    }

    public String toString() {
        String text = "";
        text = String.valueOf(text) + (this._sourceFile != null ? this._sourceFile.toString() : "null");
        text = String.valueOf(text) + " <-> ";
        text = String.valueOf(text) + (this._destinationFile != null ? this._destinationFile.toString() : "null");
        return text;
    }
}

