/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui;

import com.aptana.scripting.ScriptLogListener;
import com.aptana.scripting.ScriptLogger;
import com.aptana.scripting.ui.Messages;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ScriptingConsole {
    private static final String CONSOLE_ICON_PATH = "icons/console.png";
    private static ScriptingConsole INSTANCE;
    private MessageConsole console;
    private MessageConsoleStream outputConsoleStream;
    private MessageConsoleStream errorConsoleStream;
    private MessageConsoleStream infoConsoleStream;
    private MessageConsoleStream warningConsoleStream;
    private MessageConsoleStream traceConsoleStream;
    private Map<MessageConsoleStream, String> streamColorMap;

    public static synchronized ScriptingConsole getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ScriptingConsole();
            INSTANCE.addListeners();
        }
        return INSTANCE;
    }

    private ScriptingConsole() {
        if (this.console == null) {
            this.console = new MessageConsole(Messages.ScriptingConsole_SCRIPTING_CONSOLE_NAME, ScriptingUIPlugin.getImageDescriptor(CONSOLE_ICON_PATH));
            this.streamColorMap = new HashMap<MessageConsoleStream, String>();
            this.getOutputConsoleStream();
            this.getErrorConsoleStream();
            this.getInfoConsoleStream();
            this.getWarningConsoleStream();
            this.getTraceConsoleStream();
            this.console.setAttribute("themeConsoleStreamToColor", this.streamColorMap);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        }
    }

    private void addListeners() {
        this.listenForLoggingEvents();
    }

    MessageConsoleStream getConsoleStream(final MessageConsoleStream currentStream, String colorKey) {
        if (currentStream == null || currentStream.isClosed()) {
            if (currentStream != null) {
                this.streamColorMap.remove(currentStream);
            }
            final MessageConsoleStream newStream = this.console.newMessageStream();
            this.streamColorMap.put(newStream, colorKey);
            if (currentStream != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        newStream.setColor(currentStream.getColor());
                        newStream.setFontStyle(currentStream.getFontStyle());
                    }
                });
            }
            return newStream;
        }
        return currentStream;
    }

    MessageConsoleStream getErrorConsoleStream() {
        this.errorConsoleStream = this.getConsoleStream(this.errorConsoleStream, "console.error");
        return this.errorConsoleStream;
    }

    MessageConsoleStream getInfoConsoleStream() {
        this.infoConsoleStream = this.getConsoleStream(this.infoConsoleStream, "console.input");
        return this.infoConsoleStream;
    }

    MessageConsoleStream getOutputConsoleStream() {
        this.outputConsoleStream = this.getConsoleStream(this.outputConsoleStream, "console.output");
        return this.outputConsoleStream;
    }

    MessageConsoleStream getTraceConsoleStream() {
        this.traceConsoleStream = this.getConsoleStream(this.traceConsoleStream, "console.prompt");
        return this.traceConsoleStream;
    }

    MessageConsoleStream getWarningConsoleStream() {
        this.warningConsoleStream = this.getConsoleStream(this.warningConsoleStream, "console.warning");
        return this.warningConsoleStream;
    }

    private void listenForLoggingEvents() {
        ScriptLogger.getInstance().addLogListener(new ScriptLogListener(){
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            private String formatMessage(String message) {
                return "[" + this.getDateTimeStamp() + "] " + message;
            }

            private String getDateTimeStamp() {
                return this.format.format(new Date());
            }

            public void logError(String error) {
                ScriptingConsole.this.getErrorConsoleStream().println(this.formatMessage(error));
            }

            public void logInfo(String info) {
                ScriptingConsole.this.getInfoConsoleStream().println(this.formatMessage(info));
            }

            public void logWarning(String warning) {
                ScriptingConsole.this.getWarningConsoleStream().println(this.formatMessage(warning));
            }

            public void print(String message) {
                ScriptingConsole.this.getOutputConsoleStream().println(message);
            }

            public void printError(String message) {
                ScriptingConsole.this.getErrorConsoleStream().println(message);
            }

            public void trace(String message) {
                ScriptingConsole.this.getTraceConsoleStream().println(this.formatMessage(message));
            }
        });
    }
}

