/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.EnvironmentElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.EnvNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EnvsNode
extends BaseNode<Property> {
    private static final Image ENVS_ICON = ScriptingUIPlugin.getImage("icons/folder.png");
    private EnvNode[] envs;

    EnvsNode(BundleElement bundle) {
        this(bundle.getEnvs());
    }

    EnvsNode(List<EnvironmentElement> elements) {
        ArrayList<EnvNode> items = new ArrayList<EnvNode>();
        if (elements != null) {
            for (EnvironmentElement env : elements) {
                items.add(new EnvNode(env));
            }
        }
        this.envs = items.toArray(new EnvNode[items.size()]);
    }

    @Override
    public Object[] getChildren() {
        return this.envs;
    }

    @Override
    public Image getImage() {
        return ENVS_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return Messages.EnvsNode_Envs;
    }

    @Override
    public boolean hasChildren() {
        return this.envs.length > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property implements IPropertyInformation<EnvsNode>
    {
        COUNT(Messages.EnvsNode_Envs_Count){

            public Object getPropertyValue(EnvsNode node) {
                return node.envs.length;
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }

        @Override
        public Object getPropertyValue(EnvsNode node) {
            return null;
        }
    }
}

