/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.MenuElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MenuNode
extends BaseNode<Property> {
    private static final Image MENU_ICON = ScriptingUIPlugin.getImage("icons/menu.png");
    private MenuElement menu;

    MenuNode(MenuElement menu) {
        this.menu = menu;
    }

    @Override
    public Object[] getChildren() {
        List children = this.menu.getChildren();
        Object[] result = new Object[children.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = new MenuNode((MenuElement)children.get(i));
            ++i;
        }
        return result;
    }

    @Override
    public Image getImage() {
        return MENU_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return this.menu.getDisplayName();
    }

    @Override
    public boolean hasChildren() {
        return this.menu.hasChildren();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property implements IPropertyInformation<MenuNode>
    {
        NAME(Messages.MenuNode_Menu_Name){

            public Object getPropertyValue(MenuNode node) {
                return node.menu.getDisplayName();
            }
        }
        ,
        PATH(Messages.MenuNode_Menu_Path){

            public Object getPropertyValue(MenuNode node) {
                return node.menu.getPath();
            }
        }
        ,
        SCOPE(Messages.MenuNode_Menu_Scope){

            public Object getPropertyValue(MenuNode node) {
                String scope = node.menu.getScope();
                return scope != null && scope.length() > 0 ? scope : "all";
            }
        }
        ,
        SEPARATOR(Messages.MenuNode_Menu_Separator){

            public Object getPropertyValue(MenuNode node) {
                return node.menu.isSeparator();
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }
    }
}

