/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.ProjectTemplateElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectTemplateNode
extends BaseNode<Property> {
    private static final Image PROJECT_TEMPLATE_ICON = ScriptingUIPlugin.getImage("icons/template.png");
    private ProjectTemplateElement projectTemplate;

    ProjectTemplateNode(ProjectTemplateElement projectTemplate) {
        this.projectTemplate = projectTemplate;
    }

    @Override
    public Image getImage() {
        return PROJECT_TEMPLATE_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return this.projectTemplate.getDisplayName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property implements IPropertyInformation<ProjectTemplateNode>
    {
        NAME(Messages.ProjectTemplateNode_Project_Template_Name){

            public Object getPropertyValue(ProjectTemplateNode node) {
                return node.projectTemplate.getDisplayName();
            }
        }
        ,
        PATH(Messages.ProjectTemplateNode_Project_Template_Path){

            public Object getPropertyValue(ProjectTemplateNode node) {
                return node.projectTemplate.getPath();
            }
        }
        ,
        SCOPE(Messages.ProjectTemplateNode_Project_Template_Scope){

            public Object getPropertyValue(ProjectTemplateNode node) {
                String scope = node.projectTemplate.getScope();
                return scope != null && scope.length() > 0 ? scope : Messages.ProjectTemplateNode_All_Scopes;
            }
        }
        ,
        TYPE(Messages.ProjectTemplateNode_Project_Template_File_Type){

            public Object getPropertyValue(ProjectTemplateNode node) {
                return node.projectTemplate.getTypeString();
            }
        }
        ,
        LOCATION(Messages.ProjectTemplateNode_Project_Template_Location){

            public Object getPropertyValue(ProjectTemplateNode node) {
                return node.projectTemplate.getLocation();
            }
        }
        ,
        DESCRIPTION(Messages.ProjectTemplateNode_Project_Template_Description){

            public Object getPropertyValue(ProjectTemplateNode node) {
                return node.projectTemplate.getDescription();
            }
        }
        ,
        ICON(Messages.ProjectTemplateNode_Project_Template_Icon_Path){

            public Object getPropertyValue(ProjectTemplateNode node) {
                return node.projectTemplate.getIcon();
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }
    }
}

