/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.SnippetCategoryElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnippetCategoryNode
extends BaseNode<Property> {
    private static final Image SNIPPET_CATEGORY_ICON = ScriptingUIPlugin.getImage("icons/snippet_category.png");
    private SnippetCategoryElement snippetCategory;

    public SnippetCategoryNode(SnippetCategoryElement category) {
        this.snippetCategory = category;
    }

    @Override
    public Image getImage() {
        return SNIPPET_CATEGORY_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return this.snippetCategory.getDisplayName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property implements IPropertyInformation<SnippetCategoryNode>
    {
        NAME(Messages.SnippetCategoryNode_Snippet_Name){

            public Object getPropertyValue(SnippetCategoryNode node) {
                return node.snippetCategory.getDisplayName();
            }
        }
        ,
        PATH(Messages.SnippetCategoryNode_Snippet_Path){

            public Object getPropertyValue(SnippetCategoryNode node) {
                return node.snippetCategory.getPath();
            }
        }
        ,
        SCOPE(Messages.SnippetCategoryNode_Snippet_Scope){

            public Object getPropertyValue(SnippetCategoryNode node) {
                String scope = node.snippetCategory.getScope();
                return scope != null && scope.length() > 0 ? scope : "all";
            }
        }
        ,
        ICON_PATH(Messages.SnippetCategoryNode_Snippet_Icon_Path){

            public Object getPropertyValue(SnippetCategoryNode node) {
                return node.snippetCategory.getIconPath();
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }
    }
}

