/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.haml.internal;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.PartitionerSwitchingIgnoreRule;
import com.aptana.editor.common.text.rules.SingleCharacterRule;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.ruby.RubyCodeScanner;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.source.ISourceViewer;

public class RubyAttributesSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__hamlrubyattr_";
    public static final String DEFAULT = "__hamlrubyattr__dftl_partition_content_type";
    public static final String STRING_DOUBLE = "__hamlrubyattr_string_double";
    public static final String STRING_SINGLE = "__hamlrubyattr_string_single";
    public static final String[] CONTENT_TYPES = new String[]{"__hamlrubyattr__dftl_partition_content_type", "__hamlrubyattr_string_single", "__hamlrubyattr_string_double"};
    public static final String[] SPELLING_CONTENT_TYPES = new String[]{"__hamlrubyattr_string_single", "__hamlrubyattr_string_double"};
    private static RubyAttributesSourceConfiguration instance;
    private final IPredicateRule[] partitioningRules = new IPredicateRule[]{new PartitionerSwitchingIgnoreRule((IPredicateRule)new SingleLineRule("\"", "\"", RubyAttributesSourceConfiguration.getToken("__hamlrubyattr_string_double"), '\\')), new PartitionerSwitchingIgnoreRule((IPredicateRule)new SingleLineRule("'", "'", RubyAttributesSourceConfiguration.getToken("__hamlrubyattr_string_single"), '\\')), new SingleCharacterRule('}', RubyAttributesSourceConfiguration.getToken(null))};

    static {
        IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
        c.addTranslation(new QualifiedContentType(new String[]{DEFAULT}), new QualifiedContentType(new String[]{"meta.section.attributes.haml"}));
        c.addTranslation(new QualifiedContentType(new String[]{STRING_SINGLE}), new QualifiedContentType(new String[]{"meta.section.attributes.haml", "string.quoted.single.ruby"}));
        c.addTranslation(new QualifiedContentType(new String[]{STRING_DOUBLE}), new QualifiedContentType(new String[]{"meta.section.attributes.haml", "string.quoted.double.ruby"}));
    }

    public static synchronized RubyAttributesSourceConfiguration getDefault() {
        if (instance == null) {
            instance = new RubyAttributesSourceConfiguration();
        }
        return instance;
    }

    private RubyAttributesSourceConfiguration() {
    }

    public String[] getContentTypes() {
        return CONTENT_TYPES;
    }

    public String[] getSpellingContentTypes() {
        return SPELLING_CONTENT_TYPES;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SubPartitionScanner(this.partitioningRules, CONTENT_TYPES, RubyAttributesSourceConfiguration.getToken(DEFAULT));
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.haml";
        }
        return null;
    }

    public String[][] getTopContentTypes() {
        throw new IllegalStateException("Should never been called");
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        dr = new ThemeingDamagerRepairer(this.getSingleQuotedStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_SINGLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_SINGLE);
        dr = new ThemeingDamagerRepairer(this.getDoubleQuotedStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_DOUBLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_DOUBLE);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        return null;
    }

    private ITokenScanner getCodeScanner() {
        return new RubyCodeScanner();
    }

    private ITokenScanner getSingleQuotedStringScanner() {
        RuleBasedScanner singleQuotedStringScanner = new RuleBasedScanner();
        singleQuotedStringScanner.setDefaultReturnToken(RubyAttributesSourceConfiguration.getToken("string.quoted.single.ruby"));
        return singleQuotedStringScanner;
    }

    private ITokenScanner getDoubleQuotedStringScanner() {
        RuleBasedScanner doubleQuotedStringScanner = new RuleBasedScanner();
        doubleQuotedStringScanner.setDefaultReturnToken(RubyAttributesSourceConfiguration.getToken("string.quoted.double.ruby"));
        return doubleQuotedStringScanner;
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }
}

